/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.render.Drawable;
import org.nlogo.render.TopologyRenderer;

public strictfp class SpotlightDrawer
implements Drawable {
    private BufferedImage spotlightImage;
    static Color DIMMED = new Color(0, 0, 50, 100);
    private static final Color SPOTLIGHT_INNER_BORDER = new Color(200, 255, 255, 100);
    private static final Color SPOTLIGHT_OUTER_BORDER = new Color(200, 255, 255, 50);
    private static final Ellipse2D.Double ellipse = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);

    public BufferedImage getImage(TopologyRenderer topologyRenderer, double d, double d2, int n, int n2, double d3, double d4, boolean bl, boolean bl2) {
        if (this.spotlightImage == null || this.spotlightImage.getWidth() != n || this.spotlightImage.getHeight() != n2) {
            this.spotlightImage = new BufferedImage(n, n2, 2);
        }
        Graphics2DWrapper graphics2DWrapper = new Graphics2DWrapper(this.spotlightImage.createGraphics());
        graphics2DWrapper.antiAliasing(true);
        if (bl) {
            graphics2DWrapper.setComposite(AlphaComposite.Src);
            graphics2DWrapper.setColor(DIMMED);
            graphics2DWrapper.fillRect(0, 0, n, n2);
        } else {
            graphics2DWrapper.setComposite(AlphaComposite.Clear);
            graphics2DWrapper.setColor(DIMMED);
            graphics2DWrapper.fillRect(0, 0, n, n2);
        }
        if (bl2) {
            topologyRenderer.wrapDrawable(this, graphics2DWrapper, d, d2, d4, d3);
        } else {
            graphics2DWrapper.push();
            double d5 = d4 * d3 + this.adjustSize(d4, d3);
            double d6 = d5 / 2.0;
            double d7 = topologyRenderer.graphicsX(d, d3) - d6;
            double d8 = topologyRenderer.graphicsY(d2, d3) - d6;
            graphics2DWrapper.translate(d7, d8);
            this.draw(graphics2DWrapper, d5);
            graphics2DWrapper.pop();
        }
        graphics2DWrapper.antiAliasing(false);
        return this.spotlightImage;
    }

    public double adjustSize(double d, double d2) {
        double d3 = StrictMath.max(this.spotlightImage.getWidth(), this.spotlightImage.getHeight()) / 20;
        return d * d2 < d3 ? d3 - d : 0.0;
    }

    public void draw(GraphicsInterface graphicsInterface, double d) {
        graphicsInterface.setComposite(AlphaComposite.Clear);
        this.drawEllipse(graphicsInterface, 8.0 + d, -4.0);
        graphicsInterface.setComposite(AlphaComposite.Src);
        graphicsInterface.setColor(DIMMED);
        this.drawEllipse(graphicsInterface, 10.0 + d, -5.0);
        graphicsInterface.setColor(SPOTLIGHT_OUTER_BORDER);
        this.drawEllipse(graphicsInterface, 8.0 + d, -4.0);
        graphicsInterface.setColor(SPOTLIGHT_INNER_BORDER);
        this.drawEllipse(graphicsInterface, 4.0 + d, -2.0);
        graphicsInterface.setComposite(AlphaComposite.Clear);
        this.drawEllipse(graphicsInterface, d, 0.0);
    }

    private void drawEllipse(GraphicsInterface graphicsInterface, double d, double d2) {
        graphicsInterface.push();
        graphicsInterface.translate(d2, d2);
        graphicsInterface.scale(d, d);
        graphicsInterface.fill(ellipse);
        graphicsInterface.pop();
    }
}

