/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.ShapeList;
import org.nlogo.api.Turtle;
import org.nlogo.render.Drawable;
import org.nlogo.render.TopologyRenderer;
import org.nlogo.render.TurtleShapeManager;
import org.nlogo.render.VectorShapeDrawable;
import org.nlogo.shape.VectorShape;

public strictfp class TurtleDrawer {
    final TurtleShapeManager shapes;

    public TurtleDrawer(ShapeList shapeList) {
        this.shapes = new TurtleShapeManager(shapeList);
    }

    public void drawTurtle(GraphicsInterface graphicsInterface, TopologyRenderer topologyRenderer, Turtle turtle2, double d) {
        if (!turtle2.hidden()) {
            if (turtle2.size() * d >= 3.0) {
                this.drawTurtleShape(graphicsInterface, topologyRenderer, turtle2, d);
            } else {
                topologyRenderer.drawWrappedRect(graphicsInterface, org.nlogo.api.Color.getColor(turtle2.color()), 0.0f, turtle2.xcor(), turtle2.ycor(), turtle2.size(), d, true);
            }
            if (turtle2.hasLabel()) {
                this.drawTurtleLabel(graphicsInterface, topologyRenderer, turtle2, d);
            }
        }
    }

    void drawTurtleShape(GraphicsInterface graphicsInterface, TopologyRenderer topologyRenderer, Turtle turtle2, double d) {
        Drawable drawable = this.getShapeFromCacheOrCreateDrawable(turtle2, d, this.shapes.getShape(turtle2));
        topologyRenderer.wrapDrawable(drawable, graphicsInterface, turtle2.xcor(), turtle2.ycor(), turtle2.size(), d);
    }

    private Drawable getShapeFromCacheOrCreateDrawable(Turtle turtle2, double d, VectorShape vectorShape) {
        if (this.shapes.useCache(turtle2, d) && !vectorShape.isTooSimpleToCache()) {
            Color color = org.nlogo.api.Color.getColor(turtle2.color());
            Color color2 = vectorShape.fgRecolorable() ? color : new Color(255, 255, 255, color.getAlpha());
            return this.shapes.getCachedShape(vectorShape, color2, turtle2.heading(), turtle2.size());
        }
        return new VectorShapeDrawable(vectorShape, org.nlogo.api.Color.getColor(turtle2.color()), d, (int)turtle2.heading(), turtle2.lineThickness(), turtle2.size());
    }

    void drawTurtleWithOutline(GraphicsInterface graphicsInterface, TopologyRenderer topologyRenderer, Turtle turtle2, double d) {
        if (!turtle2.hidden()) {
            if (turtle2.size() * d >= 3.0) {
                this.drawTurtleShapeWithOutline(graphicsInterface, topologyRenderer, turtle2, d);
            } else {
                this.drawWrappedRectWithOutline(graphicsInterface, topologyRenderer, turtle2, d);
            }
            if (turtle2.hasLabel()) {
                this.drawTurtleLabel(graphicsInterface, topologyRenderer, turtle2, d);
            }
        }
    }

    private void drawTurtleShapeWithOutline(GraphicsInterface graphicsInterface, TopologyRenderer topologyRenderer, Turtle turtle2, double d) {
        double d2 = turtle2.size();
        double d3 = turtle2.xcor();
        double d4 = turtle2.ycor();
        VectorShape vectorShape = this.shapes.getShape(turtle2);
        VectorShape vectorShape2 = (VectorShape)vectorShape.clone();
        vectorShape2.setOutline();
        double d5 = StrictMath.min(d2 / 5.0, 0.5);
        Color color = org.nlogo.api.Color.getColor(turtle2.color());
        int n = (int)turtle2.heading();
        topologyRenderer.wrapDrawable(new VectorShapeDrawable(vectorShape2, color, d, n, d5, d2), graphicsInterface, turtle2.xcor(), turtle2.ycor(), d2, d);
        topologyRenderer.wrapDrawable(new VectorShapeDrawable(vectorShape2, org.nlogo.api.Color.getComplement(color), d, n, d5 / 2.0, d2), graphicsInterface, d3, d4, d2, d);
        topologyRenderer.wrapDrawable(new VectorShapeDrawable(vectorShape, color, d, n, turtle2.lineThickness(), d2), graphicsInterface, d3, d4, d2, d);
    }

    private void drawWrappedRectWithOutline(GraphicsInterface graphicsInterface, TopologyRenderer topologyRenderer, Turtle turtle2, double d) {
        double d2 = turtle2.xcor();
        double d3 = turtle2.ycor();
        double d4 = turtle2.size();
        Color color = org.nlogo.api.Color.getColor(turtle2.color());
        topologyRenderer.drawWrappedRect(graphicsInterface, color, 4.0f, d2, d3, d4, d, false);
        topologyRenderer.drawWrappedRect(graphicsInterface, org.nlogo.api.Color.getComplement(color), 2.0f, d2, d3, d4, d, false);
        topologyRenderer.drawWrappedRect(graphicsInterface, color, (float)d4, d2, d3, d4, d, true);
    }

    private void drawTurtleLabel(GraphicsInterface graphicsInterface, TopologyRenderer topologyRenderer, Turtle turtle2, double d) {
        topologyRenderer.drawLabelHelper(graphicsInterface, turtle2.xcor(), turtle2.ycor(), turtle2.labelString(), turtle2.labelColor(), d, turtle2.size());
    }
}

