/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.sdm;

import java.util.Arrays;
import java.util.Comparator;
import org.nlogo.api.CompilerException;
import org.nlogo.api.CompilerServices;
import org.nlogo.sdm.Converter;
import org.nlogo.sdm.Model;
import org.nlogo.sdm.ModelElement;
import org.nlogo.sdm.Rate;
import org.nlogo.sdm.Reservoir;
import org.nlogo.sdm.Stock;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.UninitializedFieldError;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Translator
implements ScalaObject {
    private final CompilerServices compiler;
    private final ListBuffer<Stock> stocks;
    private final ListBuffer<Rate> rates;
    private final ListBuffer<Converter> converters;
    private final ListBuffer<Converter> constantConverters;
    private final String dt;
    private volatile int bitmap$init$0;

    public ListBuffer<Stock> stocks() {
        if ((this.bitmap$init$0 & 1) != 0) {
            return this.stocks;
        }
        throw new UninitializedFieldError("Uninitialized field: Translator.scala: 13".toString());
    }

    public ListBuffer<Rate> rates() {
        if ((this.bitmap$init$0 & 2) != 0) {
            return this.rates;
        }
        throw new UninitializedFieldError("Uninitialized field: Translator.scala: 14".toString());
    }

    public ListBuffer<Converter> converters() {
        if ((this.bitmap$init$0 & 4) != 0) {
            return this.converters;
        }
        throw new UninitializedFieldError("Uninitialized field: Translator.scala: 15".toString());
    }

    public ListBuffer<Converter> constantConverters() {
        if ((this.bitmap$init$0 & 8) != 0) {
            return this.constantConverters;
        }
        throw new UninitializedFieldError("Uninitialized field: Translator.scala: 16".toString());
    }

    public String dt() {
        if ((this.bitmap$init$0 & 0x10) != 0) {
            return this.dt;
        }
        throw new UninitializedFieldError("Uninitialized field: Translator.scala: 17".toString());
    }

    public String source() {
        Stock[] stockArray = (Stock[])this.stocks().toArray(ClassManifest$.MODULE$.classType(Stock.class));
        Arrays.sort((Object[])stockArray, new StockComparator(this));
        ObjectRef objectRef = new ObjectRef("");
        ObjectRef objectRef2 = new ObjectRef("");
        ObjectRef objectRef3 = new ObjectRef("");
        objectRef.elem = new StringBuilder().append((Object)((String)objectRef.elem)).append((Object)";; System dynamics model globals\nglobals [\n").toString();
        objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)";; Initializes the system dynamics model.\n;; Call this in your model's SETUP procedure.\n").toString();
        objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)new StringBuilder().append((Object)"to system-dynamics-setup\n  reset-ticks\n  set dt ").append((Object)this.dt()).append((Object)"\n").toString()).toString();
        if (!this.constantConverters().isEmpty()) {
            objectRef.elem = new StringBuilder().append((Object)((String)objectRef.elem)).append((Object)"  ;; constants\n").toString();
            objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)"  ;; initialize constant values\n").toString();
            this.constantConverters().foreach(new Serializable(this, objectRef, objectRef2){
                public static final long serialVersionUID;
                private final Translator $outer;
                private final ObjectRef globals$1;
                private final ObjectRef procedures$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Converter converter) {
                    this.globals$1.elem = new StringBuilder().append((Object)((String)this.globals$1.elem)).append((Object)new StringBuilder().append((Object)"  ").append((Object)converter.name()).append((Object)"\n").toString()).toString();
                    this.procedures$1.elem = new StringBuilder().append((Object)((String)this.procedures$1.elem)).append((Object)this.$outer.initialValueExpressionForConverter(converter)).toString();
                }
                {
                    if (translator == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = translator;
                    this.globals$1 = objectRef;
                    this.procedures$1 = objectRef2;
                }
            });
        }
        if (!this.stocks().isEmpty()) {
            objectRef.elem = new StringBuilder().append((Object)((String)objectRef.elem)).append((Object)"  ;; stock values\n").toString();
            objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)"  ;; initialize stock values\n").toString();
            Predef$.MODULE$.refArrayOps((Object[])stockArray).foreach(new Serializable(this, objectRef, objectRef2){
                public static final long serialVersionUID;
                private final Translator $outer;
                private final ObjectRef globals$1;
                private final ObjectRef procedures$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Stock stock) {
                    this.globals$1.elem = new StringBuilder().append((Object)((String)this.globals$1.elem)).append((Object)new StringBuilder().append((Object)"  ").append((Object)stock.name()).append((Object)"\n").toString()).toString();
                    this.procedures$1.elem = new StringBuilder().append((Object)((String)this.procedures$1.elem)).append((Object)this.$outer.initialValueExpressionForStock(stock)).toString();
                }
                {
                    if (translator == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = translator;
                    this.globals$1 = objectRef;
                    this.procedures$1 = objectRef2;
                }
            });
        }
        objectRef.elem = new StringBuilder().append((Object)((String)objectRef.elem)).append((Object)"  ;; size of each step, see SYSTEM-DYNAMICS-GO\n  dt\n").toString();
        objectRef.elem = new StringBuilder().append((Object)((String)objectRef.elem)).append((Object)"]\n\n").toString();
        objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)"end\n\n").toString();
        objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)";; Step through the system dynamics model by performing next iteration of Euler's method.\n").toString();
        objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)";; Call this in your model's GO procedure.\n").toString();
        objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)"to system-dynamics-go\n").toString();
        objectRef3.elem = new StringBuilder().append((Object)((String)objectRef3.elem)).append((Object)";; Plot the current state of the system dynamics model's stocks\n").toString();
        objectRef3.elem = new StringBuilder().append((Object)((String)objectRef3.elem)).append((Object)";; Call this procedure in your plot's update commands.\n").toString();
        objectRef3.elem = new StringBuilder().append((Object)((String)objectRef3.elem)).append((Object)"to system-dynamics-do-plot\n").toString();
        if (!this.converters().isEmpty() || !this.rates().isEmpty()) {
            objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)"\n  ;; compute variable and flow values once per step\n").toString();
            this.converters().foreach(new Serializable(this, objectRef2){
                public static final long serialVersionUID;
                private final ObjectRef procedures$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Converter converter) {
                    this.procedures$1.elem = new StringBuilder().append((Object)((String)this.procedures$1.elem)).append((Object)new StringBuilder().append((Object)"  let local-").append((Object)converter.name()).append((Object)" ").append((Object)converter.name()).append((Object)"\n").toString()).toString();
                }
                {
                    this.procedures$1 = objectRef;
                }
            });
            this.rates().foreach(new Serializable(this, objectRef2){
                public static final long serialVersionUID;
                private final ObjectRef procedures$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Rate rate) {
                    this.procedures$1.elem = new StringBuilder().append((Object)((String)this.procedures$1.elem)).append((Object)new StringBuilder().append((Object)"  let local-").append((Object)rate.name()).append((Object)" ").append((Object)rate.name()).append((Object)"\n").toString()).toString();
                }
                {
                    this.procedures$1 = objectRef;
                }
            });
        }
        if (!this.stocks().isEmpty()) {
            objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)"\n  ;; update stock values\n  ;; use temporary variables so order of computation doesn't affect result.\n").toString();
            Predef$.MODULE$.refArrayOps((Object[])stockArray).foreach(new Serializable(this, objectRef2, objectRef3){
                public static final long serialVersionUID;
                private final Translator $outer;
                private final ObjectRef procedures$1;
                private final ObjectRef plots$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Stock stock) {
                    this.procedures$1.elem = new StringBuilder().append((Object)((String)this.procedures$1.elem)).append((Object)this.$outer.updateStockExpression(stock)).toString();
                    this.plots$1.elem = new StringBuilder().append((Object)((String)this.plots$1.elem)).append((Object)new StringBuilder().append((Object)"  if plot-pen-exists? \"").append((Object)stock.name()).append((Object)"\" [\n").toString()).toString();
                    this.plots$1.elem = new StringBuilder().append((Object)((String)this.plots$1.elem)).append((Object)new StringBuilder().append((Object)"    set-current-plot-pen \"").append((Object)stock.name()).append((Object)"\"\n").toString()).toString();
                    this.plots$1.elem = new StringBuilder().append((Object)((String)this.plots$1.elem)).append((Object)new StringBuilder().append((Object)"    plotxy ticks ").append((Object)stock.name()).append((Object)"\n").toString()).toString();
                    this.plots$1.elem = new StringBuilder().append((Object)((String)this.plots$1.elem)).append((Object)"  ]\n").toString();
                }
                {
                    if (translator == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = translator;
                    this.procedures$1 = objectRef;
                    this.plots$1 = objectRef2;
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])stockArray).foreach(new Serializable(this, objectRef2){
                public static final long serialVersionUID;
                private final ObjectRef procedures$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Stock stock) {
                    this.procedures$1.elem = new StringBuilder().append((Object)((String)this.procedures$1.elem)).append((Object)new StringBuilder().append((Object)"  set ").append((Object)stock.name()).append((Object)" new-").append((Object)stock.name()).append((Object)"\n").toString()).toString();
                }
                {
                    this.procedures$1 = objectRef;
                }
            });
        }
        objectRef2.elem = new StringBuilder().append((Object)((String)objectRef2.elem)).append((Object)"\n  tick-advance dt\nend\n\n").toString();
        objectRef3.elem = new StringBuilder().append((Object)((String)objectRef3.elem)).append((Object)"end\n\n").toString();
        this.rates().foreach(new Serializable(this, objectRef2){
            public static final long serialVersionUID;
            private final Translator $outer;
            private final ObjectRef procedures$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Rate rate) {
                this.procedures$1.elem = new StringBuilder().append((Object)((String)this.procedures$1.elem)).append((Object)this.$outer.org$nlogo$sdm$Translator$$procedureForRate(rate)).toString();
            }
            {
                if (translator == null) {
                    throw new NullPointerException();
                }
                this.$outer = translator;
                this.procedures$1 = objectRef;
            }
        });
        this.converters().foreach(new Serializable(this, objectRef2){
            public static final long serialVersionUID;
            private final Translator $outer;
            private final ObjectRef procedures$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Converter converter) {
                this.procedures$1.elem = new StringBuilder().append((Object)((String)this.procedures$1.elem)).append((Object)this.$outer.procedureForConverter(converter)).toString();
            }
            {
                if (translator == null) {
                    throw new NullPointerException();
                }
                this.$outer = translator;
                this.procedures$1 = objectRef;
            }
        });
        return new StringBuilder().append((Object)((String)objectRef.elem)).append((Object)((String)objectRef2.elem)).append((Object)((String)objectRef3.elem)).toString();
    }

    public final String org$nlogo$sdm$Translator$$procedureForRate(Rate rate) {
        return new StringBuilder().append((Object)";; Report value of flow\nto-report ").append((Object)rate.name()).append((Object)"\n").append((Object)"  report ( ").append((Object)(rate.expression() == null ? "0" : rate.expression())).append((Object)"\n  ) * ").append((Object)"dt").append((Object)"\n").append((Object)"end\n\n").toString();
    }

    public String procedureForConverter(Converter converter) {
        return new StringBuilder().append((Object)";; Report value of variable\nto-report ").append((Object)converter.name()).append((Object)"\n").append((Object)"  report ").append((Object)(converter.expression() == null ? "0" : converter.expression())).append((Object)"\n").append((Object)"end\n\n").toString();
    }

    public String initialValueExpressionForStock(Stock stock) {
        return new StringBuilder().append((Object)"  set ").append((Object)stock.name()).append((Object)" ").append((Object)(stock.initialValueExpression() == null ? "0" : stock.initialValueExpression())).append((Object)"\n").toString();
    }

    public String initialValueExpressionForConverter(Converter converter) {
        return new StringBuilder().append((Object)"  set ").append((Object)converter.name()).append((Object)" ").append((Object)(converter.expression() == null ? "0" : converter.expression())).append((Object)"\n").toString();
    }

    public String updateStockExpression(Stock stock) {
        ObjectRef objectRef = new ObjectRef(new StringBuilder().append((Object)"  let new-").append((Object)stock.name()).append((Object)(stock.nonNegative() ? " max( list 0 ( " : " ( ")).append((Object)stock.name()).append((Object)" ").toString());
        this.rates().foreach(new Serializable(this, stock, objectRef){
            public static final long serialVersionUID;
            private final Stock s$1;
            private final ObjectRef expr$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Rate rate) {
                String string = rate.source().name();
                String string2 = this.s$1.name();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.expr$1.elem = new StringBuilder().append((Object)((String)this.expr$1.elem)).append((Object)new StringBuilder().append((Object)"- local-").append((Object)rate.name()).append((Object)" ").toString()).toString();
                }
                String string3 = rate.sink().name();
                String string4 = this.s$1.name();
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    this.expr$1.elem = new StringBuilder().append((Object)((String)this.expr$1.elem)).append((Object)new StringBuilder().append((Object)"+ local-").append((Object)rate.name()).append((Object)" ").toString()).toString();
                }
            }
            {
                this.s$1 = stock;
                this.expr$1 = objectRef;
            }
        });
        if (stock.nonNegative()) {
            objectRef.elem = new StringBuilder().append((Object)((String)objectRef.elem)).append((Object)") ").toString();
        }
        return new StringBuilder().append((Object)((String)objectRef.elem)).append((Object)")\n").toString();
    }

    public boolean isConstant(String string) {
        boolean bl = false;
        try {
            this.compiler.readFromString(string);
            bl = true;
        }
        catch (CompilerException compilerException) {
            bl = false;
        }
        return bl;
    }

    public Translator(Model model, CompilerServices compilerServices) {
        this.compiler = compilerServices;
        this.stocks = new ListBuffer();
        this.bitmap$init$0 |= 1;
        this.rates = new ListBuffer();
        this.bitmap$init$0 |= 2;
        this.converters = new ListBuffer();
        this.bitmap$init$0 |= 4;
        this.constantConverters = new ListBuffer();
        this.bitmap$init$0 |= 8;
        this.dt = ((Object)BoxesRunTime.boxToDouble(model.dt())).toString();
        this.bitmap$init$0 |= 0x10;
        model.elements().withFilter((Function1<ModelElement, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(ModelElement modelElement) {
                return !modelElement.name().isEmpty();
            }

            public final /* synthetic */ Object apply(Object object) {
                return BoxesRunTime.boxToBoolean(this.apply((ModelElement)object));
            }
        })).foreach(new Serializable(this){
            public static final long serialVersionUID;
            private final Translator $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(ModelElement modelElement) {
                Converter converter;
                Converter converter2;
                Rate rate;
                Rate rate2;
                ModelElement modelElement2 = modelElement;
                Object object = modelElement2 instanceof Reservoir ? BoxedUnit.UNIT : (modelElement2 instanceof Stock ? this.$outer.stocks().$plus$eq((Object)((Stock)modelElement2)) : (modelElement2 instanceof Rate ? ((rate2 = (rate = (Rate)modelElement2)).expression().isEmpty() ? BoxedUnit.UNIT : this.$outer.rates().$plus$eq((Object)rate2)) : (modelElement2 instanceof Converter ? ((converter2 = (converter = (Converter)modelElement2)).expression().isEmpty() ? BoxedUnit.UNIT : (this.$outer.isConstant(converter2.expression().toUpperCase()) ? this.$outer.constantConverters().$plus$eq((Object)converter2) : this.$outer.converters().$plus$eq((Object)converter2))) : BoxedUnit.UNIT)));
                return object;
            }
            {
                if (translator == null) {
                    throw new NullPointerException();
                }
                this.$outer = translator;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StockComparator
    implements Comparator<Stock>,
    ScalaObject {
        public final Translator $outer;

        @Override
        public int compare(Stock stock, Stock stock2) {
            String string = stock.name().toUpperCase();
            String string2 = stock2.name().toUpperCase();
            String string3 = stock.initialValueExpression().toUpperCase();
            String string4 = stock2.initialValueExpression().toUpperCase();
            return this.org$nlogo$sdm$Translator$StockComparator$$$outer().isConstant(string3) ? (this.org$nlogo$sdm$Translator$StockComparator$$$outer().isConstant(string4) ? string.compareTo(string2) : -1) : (this.org$nlogo$sdm$Translator$StockComparator$$$outer().isConstant(string4) ? 1 : string.compareTo(string2));
        }

        public Translator org$nlogo$sdm$Translator$StockComparator$$$outer() {
            return this.$outer;
        }

        public StockComparator(Translator translator) {
            if (translator == null) {
                throw new NullPointerException();
            }
            this.$outer = translator;
        }
    }
}

