/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.shape.Curve;
import org.nlogo.shape.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Polygon
extends Curve
implements Cloneable {
    public int latestIndex = 1;
    public boolean notCompleted = false;

    public Polygon(List<Integer> list, List<Integer> list2, Color color) {
        super(color);
        this.xcoords = list;
        this.ycoords = list2;
    }

    @Override
    public void setFilled(boolean bl) {
        this.filled = bl;
    }

    @Override
    public Object clone() {
        Polygon polygon = (Polygon)super.clone();
        polygon.xcoords = new ArrayList(polygon.xcoords);
        polygon.ycoords = new ArrayList(polygon.ycoords);
        return polygon;
    }

    @Override
    public void draw(GraphicsInterface graphicsInterface, Color color, double d, double d2) {
        if (this.notCompleted) {
            super.draw(graphicsInterface, null, d, d2);
        } else {
            int[] nArray = new int[this.xcoords.size()];
            int[] nArray2 = new int[this.xcoords.size()];
            for (int i = 0; i < this.xcoords.size(); ++i) {
                nArray[i] = this.getElt(i, this.xcoords);
                nArray2[i] = this.getElt(i, this.ycoords);
            }
            graphicsInterface.setColor(this.getColor(color));
            if (this.filled) {
                graphicsInterface.fillPolygon(nArray, nArray2, this.xcoords.size());
            } else {
                graphicsInterface.drawPolygon(nArray, nArray2, this.xcoords.size());
            }
        }
    }

    @Override
    boolean shouldSave() {
        return this.xcoords.size() >= 2;
    }

    @Override
    public String toString() {
        String string = "";
        string = string + "Polygon " + this.c.getRGB() + " " + this.filled + " " + this.marked;
        for (int i = 0; i < this.xcoords.size(); ++i) {
            string = string + " " + this.getElt(i, this.xcoords) + " " + this.getElt(i, this.ycoords);
        }
        return string;
    }

    public static Polygon parsePolygon(String string) {
        Serializable serializable;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        boolean bl = stringTokenizer.nextToken().equals("true");
        boolean bl2 = stringTokenizer.nextToken().equals("true");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        Serializable serializable2 = null;
        Integer n = null;
        while (stringTokenizer.hasMoreTokens()) {
            serializable = Integer.valueOf(stringTokenizer.nextToken());
            Integer n2 = Integer.valueOf(stringTokenizer.nextToken());
            if (!((Integer)serializable).equals(serializable2) || !n2.equals(n)) {
                arrayList.add((Integer)serializable);
                arrayList2.add(n2);
            }
            serializable2 = serializable;
            n = n2;
        }
        if (arrayList.size() < 2) {
            return null;
        }
        serializable = new Polygon(arrayList, arrayList2, Color.decode(string2));
        ((Polygon)serializable).setFilled(bl);
        ((Element)serializable).setMarked(bl2);
        return serializable;
    }
}

