/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.nlogo.api.Color;
import org.nlogo.api.Constants;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Shape;
import org.nlogo.api.ShapeList;
import org.nlogo.api.VersionHistory;
import org.nlogo.shape.Circle;
import org.nlogo.shape.Element;
import org.nlogo.shape.Line;
import org.nlogo.shape.Polygon;
import org.nlogo.shape.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class VectorShape
extends Observable
implements Serializable,
Cloneable,
Shape {
    protected String name = "";
    protected int editableColorIndex;
    protected List<Element> elementList = new ArrayList<Element>();
    protected boolean rotatable = true;
    private Recolorable fgRecolorable = Recolorable.UNKNOWN;

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setEditableColorIndex(int n) {
        this.editableColorIndex = n;
    }

    public Object clone() {
        VectorShape vectorShape;
        try {
            vectorShape = (VectorShape)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
        vectorShape.elementList = new ArrayList<Element>();
        for (Element element : this.elementList) {
            vectorShape.elementList.add((Element)element.clone());
        }
        return vectorShape;
    }

    public void setOutline() {
        for (Element element : this.elementList) {
            element.setFilled(false);
        }
    }

    public void setRotatable(boolean bl) {
        this.rotatable = bl;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public boolean fgRecolorable() {
        if (this.fgRecolorable == Recolorable.UNKNOWN) {
            this.fgRecolorable = Recolorable.FALSE;
            java.awt.Color color = new java.awt.Color(Color.getARGBByIndex(this.editableColorIndex));
            int n = this.elementList.size();
            for (int i = 0; i < n; ++i) {
                if (!this.element(i).getColor().equals(color)) continue;
                this.fgRecolorable = Recolorable.TRUE;
                break;
            }
        }
        return this.fgRecolorable == Recolorable.TRUE;
    }

    public boolean isTooSimpleToCache() {
        switch (this.elementList.size()) {
            case 0: {
                return true;
            }
            case 1: {
                Element element = this.element(0);
                return !(element instanceof Polygon);
            }
        }
        return false;
    }

    protected Element element(int n) {
        return this.elementList.get(n);
    }

    public void add(Element element) {
        this.elementList.add(element);
        if (element instanceof Rectangle) {
            ((Rectangle)element).setMaxsAndMins();
        }
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(GraphicsInterface graphicsInterface, java.awt.Color color, double d, double d2, double d3, double d4, int n, double d5) {
        graphicsInterface.push();
        double d6 = d3 * d4;
        if (!this.isRotatable()) {
            n = 0;
        }
        try {
            if (n != 0) {
                graphicsInterface.rotate((double)n / 180.0 * Math.PI, d, d2, d6);
            }
            graphicsInterface.translate(d, d2);
            graphicsInterface.scale(d6, d6, Constants.ShapeWidth());
            graphicsInterface.setStrokeFromLineThickness(d5, d6, d4, Constants.ShapeWidth());
            for (int i = 0; i < this.elementList.size(); ++i) {
                this.element(i).draw(graphicsInterface, color, d6, n);
            }
        }
        finally {
            graphicsInterface.pop();
        }
    }

    public void paint(GraphicsInterface graphicsInterface, java.awt.Color color, int n, int n2, double d, int n3) {
        this.paint(graphicsInterface, color, n, n2, 1.0, d, n3, 0.0);
    }

    public String toString() {
        String string = this.name + "\n" + this.rotatable + "\n" + this.editableColorIndex;
        for (int i = 0; i < this.elementList.size(); ++i) {
            Element element = this.elementList.get(i);
            if (!element.shouldSave()) continue;
            string = string + "\n" + element.toString();
        }
        return string;
    }

    public void addElement(String string) {
        this.addElement(string, false);
    }

    public void addElement(String string, boolean bl) {
        Element element = null;
        if (string.startsWith("Line")) {
            element = Line.parseLine(string);
        } else if (string.startsWith("Rectangle")) {
            element = Rectangle.parseRectangle(string);
        } else if (string.startsWith("Circle")) {
            element = Circle.parseCircle(string);
        } else if (string.startsWith("Polygon")) {
            element = Polygon.parsePolygon(string);
        } else {
            throw new IllegalStateException("Invalid shape format in file: " + string);
        }
        if (element != null) {
            if (bl) {
                element.setColor(new java.awt.Color(Color.translateSavedColor(element.getColor().getRGB())));
            }
            this.add(element);
        }
    }

    public static List<Shape> parseShapes(String[] stringArray, String string) {
        int n;
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        for (n = 0; stringArray.length > n && 0 == VectorShape.getString(stringArray, n).length(); ++n) {
        }
        while (stringArray.length > n) {
            try {
                VectorShape vectorShape = new VectorShape();
                n = VectorShape.parseShape(stringArray, string, vectorShape, n);
                arrayList.add(vectorShape);
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
            ++n;
        }
        return arrayList;
    }

    public static int parseShape(String[] stringArray, String string, VectorShape vectorShape, int n) {
        boolean bl;
        vectorShape.setName(VectorShape.getString(stringArray, n++));
        if (vectorShape.getName().indexOf("StarLogoT") != -1) {
            throw new IllegalStateException("found StarLogoT version instead of shape");
        }
        vectorShape.setRotatable(VectorShape.getString(stringArray, n++).equals("true"));
        int n2 = Integer.valueOf(VectorShape.getString(stringArray, n++));
        boolean bl2 = bl = string != null && (VersionHistory.olderThan30pre5(string) || VersionHistory.olderThan3DPreview3(string));
        if (bl) {
            n2 = Color.translateSavedColor(n2);
        }
        vectorShape.setEditableColorIndex(n2);
        while (0 != VectorShape.getString(stringArray, n).length()) {
            vectorShape.addElement(VectorShape.getString(stringArray, n++), bl);
        }
        return n;
    }

    static String getString(String[] stringArray, int n) {
        if (null != stringArray && stringArray.length > n) {
            return stringArray[n];
        }
        return "";
    }

    public static VectorShape getDefaultShape() {
        VectorShape vectorShape = new VectorShape();
        vectorShape.setName(ShapeList.DefaultShapeName());
        vectorShape.setRotatable(true);
        vectorShape.setEditableColorIndex(0);
        vectorShape.addElement("Polygon -7500403 true true 150 5 40 250 150 205 260 250");
        return vectorShape;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private strictfp static enum Recolorable {
        UNKNOWN,
        TRUE,
        FALSE;

    }
}

