/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JOptionPane;
import net.roydesign.mac.MRJAdapter;

public class BrowserLauncher {
    public static strictfp void openURL(Component component, String string, boolean bl) {
        BrowserLauncher.openURL(component, string, "", bl);
    }

    public static strictfp void openURL(Component component, String string, String string2, boolean bl) {
        try {
            if (bl) {
                string = BrowserLauncher.makeURLFromFile(new File(string));
            }
            BrowserLauncher.openURL(string + string2);
        }
        catch (BrowserNotFoundException browserNotFoundException) {
            JOptionPane.showMessageDialog(component, browserNotFoundException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    private static strictfp String makeURLFromFile(File file) {
        return BrowserLauncher.makeURLFromFilePath(file.getAbsolutePath());
    }

    private static strictfp String makeURLFromFilePath(String string) {
        try {
            return new URI("file", string, null).toURL().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException(uRISyntaxException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(malformedURLException);
        }
    }

    private static strictfp void openURL(String string) throws BrowserNotFoundException, IOException {
        String string2 = System.getProperty("os.name");
        if (string2.startsWith("Mac")) {
            MRJAdapter.openURL((String)string);
        } else {
            Object object;
            try {
                object = Class.forName("java.awt.Desktop");
                Object object2 = ((Class)object).getMethod("isDesktopSupported", new Class[0]).invoke(null, new Object[0]);
                if (object2 instanceof Boolean && ((Boolean)object2).booleanValue()) {
                    Object object3 = ((Class)object).getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    ((Class)object).getMethod("browse", URI.class).invoke(object3, new URI(string));
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2.startsWith("Windows")) {
                Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "start", "\"\"", '\"' + string + '\"'});
            } else {
                try {
                    object = Runtime.getRuntime().exec(new String[]{"firefox", "-remote", "'openURL(", string + ")'"});
                    int n = ((Process)object).waitFor();
                    if (n != 0) {
                        Runtime.getRuntime().exec(new String[]{"firefox", string});
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new IllegalStateException(interruptedException);
                }
                catch (IOException iOException) {
                    throw new BrowserNotFoundException("NetLogo could not find and execute a web browser named 'firefox'.Please install Firefox and ensure that the 'firefox' command is in your executable PATH.  Firefox is available here:\n http://www.mozilla.com/firefox/\n\nThe full error message was:\n " + iOException.getLocalizedMessage());
                }
            }
        }
    }

    strictfp static class BrowserNotFoundException
    extends Exception {
        BrowserNotFoundException(String string) {
            super(string);
        }
    }
}

