/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import org.nlogo.api.Color$;
import org.nlogo.api.Editable;
import org.nlogo.api.I18N$;
import org.nlogo.api.ModelReader$;
import org.nlogo.api.Property;
import org.nlogo.awt.Fonts$;
import org.nlogo.awt.LineBreaker$;
import org.nlogo.widget.Properties$;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.SingleErrorWidget;
import org.nlogo.window.Widget;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.UninitializedFieldError;
import scala.collection.IndexedSeq;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoteWidget
extends SingleErrorWidget
implements Editable,
ScalaObject {
    private final int MIN_WIDTH;
    private final int DEFAULT_WIDTH;
    private final int MIN_HEIGHT;
    private int _width;
    private String _text;
    private int _fontSize;
    private Color color;
    private volatile int bitmap$init$0;

    public int MIN_WIDTH() {
        if ((this.bitmap$init$0 & 1) != 0) {
            return this.MIN_WIDTH;
        }
        throw new UninitializedFieldError("Uninitialized field: NoteWidget.scala: 15".toString());
    }

    public int DEFAULT_WIDTH() {
        if ((this.bitmap$init$0 & 2) != 0) {
            return this.DEFAULT_WIDTH;
        }
        throw new UninitializedFieldError("Uninitialized field: NoteWidget.scala: 16".toString());
    }

    public int MIN_HEIGHT() {
        if ((this.bitmap$init$0 & 4) != 0) {
            return this.MIN_HEIGHT;
        }
        throw new UninitializedFieldError("Uninitialized field: NoteWidget.scala: 17".toString());
    }

    private int _width() {
        if ((this.bitmap$init$0 & 8) != 0) {
            return this._width;
        }
        throw new UninitializedFieldError("Uninitialized field: NoteWidget.scala: 19".toString());
    }

    private void _width_$eq(int n) {
        this._width = n;
        this.bitmap$init$0 |= 8;
    }

    private String _text() {
        if ((this.bitmap$init$0 & 0x10) != 0) {
            return this._text;
        }
        throw new UninitializedFieldError("Uninitialized field: NoteWidget.scala: 20".toString());
    }

    private void _text_$eq(String string) {
        this._text = string;
        this.bitmap$init$0 |= 0x10;
    }

    private int _fontSize() {
        if ((this.bitmap$init$0 & 0x20) != 0) {
            return this._fontSize;
        }
        throw new UninitializedFieldError("Uninitialized field: NoteWidget.scala: 21".toString());
    }

    private void _fontSize_$eq(int n) {
        this._fontSize = n;
        this.bitmap$init$0 |= 0x20;
    }

    public Color color() {
        if ((this.bitmap$init$0 & 0x40) != 0) {
            return this.color;
        }
        throw new UninitializedFieldError("Uninitialized field: NoteWidget.scala: 22".toString());
    }

    public void color_$eq(Color color) {
        this.color = color;
        this.bitmap$init$0 |= 0x40;
    }

    @Override
    public List<Property> propertySet() {
        return Properties$.MODULE$.text();
    }

    @Override
    public String classDisplayName() {
        return I18N$.MODULE$.gui().get("tabs.run.widgets.note");
    }

    @Override
    public boolean isNote() {
        return true;
    }

    @Override
    public boolean widgetWrapperOpaque() {
        return !this.transparency();
    }

    public String text() {
        return this._text();
    }

    public void text_$eq(String string) {
        this._text_$eq(string);
        this.displayName_$eq(string);
        this.repaint();
    }

    public boolean transparency() {
        return this.getBackground() == InterfaceColors.TRANSPARENT;
    }

    public void transparency(boolean bl) {
        this.setBackground(bl ? InterfaceColors.TRANSPARENT : InterfaceColors.TEXT_BOX_BACKGROUND);
        this.setOpaque(!bl);
    }

    public int fontSize() {
        return this._fontSize();
    }

    public void fontSize_$eq(int n) {
        this._fontSize_$eq(n);
        if (this.isZoomed() && this.originalFont() != null) {
            int n2 = this.getFont().getSize() - this.originalFont().getSize();
            this.setFont(this.getFont().deriveFont((float)(n + n2)));
        } else {
            this.setFont(this.getFont().deriveFont((float)n));
        }
        if (this.originalFont() != null) {
            this.originalFont_$eq(this.originalFont().deriveFont((float)n));
        }
        this.resetZoomInfo();
        this.resetSizeInfo();
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        if (rectangle.width > 0) {
            this._width_$eq(rectangle.width);
        }
        super.setBounds(rectangle);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 > 0) {
            this._width_$eq(n3);
        }
        super.setBounds(n, n2, n3, n4);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.MIN_WIDTH(), this.MIN_HEIGHT());
    }

    @Override
    public Dimension getPreferredSize(Font font) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = LineBreaker$.MODULE$.breakLines(this._text(), fontMetrics, this._width()).size() * (fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent());
        return new Dimension(StrictMath.max(this.MIN_WIDTH(), this._width()), StrictMath.max(this.MIN_HEIGHT(), n));
    }

    @Override
    public boolean needsPreferredWidthFudgeFactor() {
        return false;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
        int n2 = fontMetrics.getMaxAscent();
        List<String> list = LineBreaker$.MODULE$.breakLines(this._text(), fontMetrics, this._width());
        graphics.setColor(this.color());
        ((IterableLike)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).filter(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, Object> tuple2) {
                Tuple2<String, Object> tuple22 = tuple2;
                return tuple22 != null;
            }

            public final /* synthetic */ Object apply(Object object) {
                return BoxesRunTime.boxToBoolean(this.apply((Tuple2)object));
            }
        })).foreach(new Serializable(this, graphics, n, n2){
            public static final long serialVersionUID;
            private final Graphics g$1;
            private final int stringHeight$1;
            private final int stringAscent$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, Object> tuple2) {
                Tuple2<String, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    this.g$1.drawString(tuple22._1(), 0, BoxesRunTime.unboxToInt(tuple22._2()) * this.stringHeight$1 + this.stringAscent$1);
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                this.g$1 = graphics;
                this.stringHeight$1 = n;
                this.stringAscent$1 = n2;
            }
        });
    }

    @Override
    public String save() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TEXTBOX\n");
        stringBuilder.append(this.getBoundsString());
        String string = this._text().trim();
        String string2 = "";
        StringBuilder stringBuilder2 = !(string != null ? !string.equals(string2) : string2 != null) ? stringBuilder.append("NIL\n") : stringBuilder.append(new StringBuilder().append((Object)ModelReader$.MODULE$.stripLines(this._text())).append((Object)"\n").toString());
        stringBuilder.append(new StringBuilder().append(this.fontSize()).append((Object)"\n").toString());
        stringBuilder.append(new StringBuilder().append(Color$.MODULE$.getClosestColorNumberByARGB(this.color().getRGB())).append((Object)"\n").toString());
        stringBuilder.append(new StringBuilder().append((Object)(this.transparency() ? "1" : "0")).append((Object)"\n").toString());
        return stringBuilder.toString();
    }

    @Override
    public NoteWidget load(String[] stringArray, Widget.LoadHelper loadHelper2) {
        String string = stringArray[5];
        String string2 = "NIL";
        this.text_$eq(!(string != null ? !string.equals(string2) : string2 != null) ? "" : ModelReader$.MODULE$.restoreLines(stringArray[5]));
        if (stringArray.length >= 7) {
            this.fontSize_$eq(Predef$.MODULE$.augmentString(stringArray[6]).toInt());
        }
        if (stringArray.length >= 8) {
            this.color_$eq(Color$.MODULE$.getColor(Predef$.MODULE$.double2Double(Predef$.MODULE$.augmentString(stringArray[7]).toDouble())));
        }
        if (stringArray.length >= 9) {
            this.transparency(Predef$.MODULE$.augmentString(stringArray[8]).toInt() != 0);
        } else {
            this.transparency(false);
        }
        int[] nArray = (int[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])stringArray).drop(1)).take(4)).map(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(String string) {
                return Predef$.MODULE$.augmentString(string).toInt();
            }

            public final /* synthetic */ Object apply(Object object) {
                return BoxesRunTime.boxToInteger(this.apply((String)object));
            }
        }, Array$.MODULE$.canBuildFrom(Manifest$.MODULE$.Int()));
        Option option = Array$.MODULE$.unapplySeq(nArray);
        if (option.isEmpty()) {
            throw new MatchError(nArray);
        }
        IndexedSeq indexedSeq = option.get();
        if (indexedSeq == null ? false : indexedSeq.lengthCompare(4) == 0) {
            Tuple4 tuple4 = new Tuple4(indexedSeq.apply(0), indexedSeq.apply(1), indexedSeq.apply(2), indexedSeq.apply(3));
            int n = BoxesRunTime.unboxToInt(tuple4._1());
            int n2 = BoxesRunTime.unboxToInt(tuple4._2());
            int n3 = BoxesRunTime.unboxToInt(tuple4._3());
            int n4 = BoxesRunTime.unboxToInt(tuple4._4());
            this.setSize(n3 - n, n4 - n2);
            return this;
        }
        throw new MatchError(nArray);
    }

    public NoteWidget() {
        this.setBackground(InterfaceColors.TRANSPARENT);
        this.setOpaque(false);
        Fonts$.MODULE$.adjustDefaultFont(this);
        this.MIN_WIDTH = 15;
        this.bitmap$init$0 |= 1;
        this.DEFAULT_WIDTH = 150;
        this.bitmap$init$0 |= 2;
        this.MIN_HEIGHT = 18;
        this.bitmap$init$0 |= 4;
        this._width = this.DEFAULT_WIDTH();
        this.bitmap$init$0 |= 8;
        this._text = "";
        this.bitmap$init$0 |= 0x10;
        this._fontSize = this.getFont().getSize();
        this.bitmap$init$0 |= 0x20;
        this.color = Color.black;
        this.bitmap$init$0 |= 0x40;
    }
}

