/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.nlogo.api.CompilerException;
import org.nlogo.api.Editable;
import org.nlogo.api.I18N$;
import org.nlogo.api.Property;
import org.nlogo.api.StringUtils$;
import org.nlogo.awt.Fonts$;
import org.nlogo.plot.Plot;
import org.nlogo.plot.PlotLoader$;
import org.nlogo.plot.PlotManagerInterface;
import org.nlogo.plot.PlotPen;
import org.nlogo.swing.VTextIcon;
import org.nlogo.window.AbstractPlotWidget$;
import org.nlogo.window.Events;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.PlotCanvas;
import org.nlogo.window.PlotLegend;
import org.nlogo.window.ProceduresInterface;
import org.nlogo.window.Properties$;
import org.nlogo.window.Widget;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.UninitializedFieldError;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Manifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPlotWidget
extends Widget
implements Editable,
Plot.DirtyListener,
Events.AfterLoadEvent.Handler,
Events.CompiledEvent.Handler,
Events.WidgetRemovedEvent.Handler,
ScalaObject {
    private final Plot plot;
    private final PlotManagerInterface plotManager;
    private boolean fullyConstructed;
    private final PlotCanvas canvas;
    private final PlotLegend legend;
    private final JLabel nameLabel;
    private final XAxisLabels xAxis;
    private final YAxisLabels yAxis;
    private String _xAxisLabel;
    private String _yAxisLabel;
    private volatile int bitmap$init$0;

    public Plot plot() {
        return this.plot;
    }

    public PlotManagerInterface plotManager() {
        return this.plotManager;
    }

    private boolean fullyConstructed() {
        if ((this.bitmap$init$0 & 1) != 0) {
            return this.fullyConstructed;
        }
        throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 24".toString());
    }

    private void fullyConstructed_$eq(boolean bl) {
        this.fullyConstructed = bl;
        this.bitmap$init$0 |= 1;
    }

    public PlotCanvas canvas() {
        if ((this.bitmap$init$0 & 2) != 0) {
            return this.canvas;
        }
        throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 26".toString());
    }

    private PlotLegend legend() {
        if ((this.bitmap$init$0 & 4) != 0) {
            return this.legend;
        }
        throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 27".toString());
    }

    private JLabel nameLabel() {
        if ((this.bitmap$init$0 & 8) != 0) {
            return this.nameLabel;
        }
        throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 28".toString());
    }

    private XAxisLabels xAxis() {
        if ((this.bitmap$init$0 & 0x10) != 0) {
            return this.xAxis;
        }
        throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 29".toString());
    }

    private YAxisLabels yAxis() {
        if ((this.bitmap$init$0 & 0x20) != 0) {
            return this.yAxis;
        }
        throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 30".toString());
    }

    public void refreshGUI() {
        this.xAxis().setMin(this.getLabel$1(this.plot().xMin()));
        this.xAxis().setMax(this.getLabel$1(this.plot().xMax()));
        this.yAxis().setMin(this.getLabel$1(this.plot().yMin()));
        this.yAxis().setMax(this.getLabel$1(this.plot().yMax()));
        if (this.plot().pensDirty()) {
            this.legend().refresh();
            this.plot().pensDirty_$eq(false);
        }
    }

    @Override
    public String classDisplayName() {
        return I18N$.MODULE$.gui().get("tabs.run.widgets.plot");
    }

    @Override
    public boolean needsPreferredWidthFudgeFactor() {
        return false;
    }

    @Override
    public boolean zoomSubcomponents() {
        return true;
    }

    @Override
    public void makeDirty() {
        if (this.fullyConstructed()) {
            this.canvas().makeDirty();
        }
    }

    public Some<String> helpLink() {
        return new Some<String>("docs/programming.html#plotting");
    }

    @Override
    public java.util.List<Property> propertySet() {
        return Properties$.MODULE$.plot();
    }

    public void clear() {
        this.plot().clear();
        this.legend().refresh();
    }

    public String plotName() {
        return this.plot().name();
    }

    public void plotName(String string) {
        this.plot().name(string);
        this.displayName_$eq(this.plot().name());
        this.nameLabel().setText(string);
    }

    private String _xAxisLabel() {
        if ((this.bitmap$init$0 & 0x40) != 0) {
            return this._xAxisLabel;
        }
        throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 182".toString());
    }

    private void _xAxisLabel_$eq(String string) {
        this._xAxisLabel = string;
        this.bitmap$init$0 |= 0x40;
    }

    public String xLabel() {
        return this.xAxis().getLabel();
    }

    public void xLabel(String string) {
        this._xAxisLabel_$eq(string);
        this.xAxis().setLabel(this._xAxisLabel());
    }

    private String _yAxisLabel() {
        if ((this.bitmap$init$0 & 0x80) != 0) {
            return this._yAxisLabel;
        }
        throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 189".toString());
    }

    private void _yAxisLabel_$eq(String string) {
        this._yAxisLabel = string;
        this.bitmap$init$0 |= 0x80;
    }

    public String yLabel() {
        return this.yAxis().getLabel();
    }

    public void yLabel(String string) {
        this._yAxisLabel_$eq(string);
        this.yAxis().setLabel(this._yAxisLabel());
    }

    @Override
    public Dimension getMinimumSize() {
        return AbstractPlotWidget$.MODULE$.MIN_SIZE();
    }

    @Override
    public Dimension getPreferredSize(Font font) {
        return AbstractPlotWidget$.MODULE$.PREF_SIZE();
    }

    @Override
    public Dimension getMaximumSize() {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String save() {
        var1_1 = new StringBuilder();
        var1_1.append("PLOT\n");
        var1_1.append(this.getBoundsString());
        v0 = new StringBuilder();
        if (this.plotName() == null) ** GOTO lbl-1000
        v1 = this.plotName().trim();
        var2_2 = "";
        if (!(v1 != null ? v1.equals(var2_2) == false : var2_2 != null)) lbl-1000:
        // 2 sources

        {
            v2 = "NIL";
        } else {
            v2 = this.plotName();
        }
        var1_1.append(v0.append((Object)v2).append((Object)"\n").toString());
        v3 = new StringBuilder();
        if (this.xLabel() == null) ** GOTO lbl-1000
        v4 = this.xLabel().trim();
        var3_3 = "";
        if (!(v4 != null ? v4.equals(var3_3) == false : var3_3 != null)) lbl-1000:
        // 2 sources

        {
            v5 = "NIL";
        } else {
            v5 = this.xLabel();
        }
        var1_1.append(v3.append((Object)v5).append((Object)"\n").toString());
        v6 = new StringBuilder();
        if (this.yLabel() == null) ** GOTO lbl-1000
        v7 = this.yLabel().trim();
        var4_4 = "";
        if (!(v7 != null ? v7.equals(var4_4) == false : var4_4 != null)) lbl-1000:
        // 2 sources

        {
            v8 = "NIL";
        } else {
            v8 = this.yLabel();
        }
        var1_1.append(v6.append((Object)v8).append((Object)"\n").toString());
        var1_1.append(new StringBuilder().append(this.plot().defaultXMin()).append((Object)"\n").toString());
        var1_1.append(new StringBuilder().append(this.plot().defaultXMax()).append((Object)"\n").toString());
        var1_1.append(new StringBuilder().append(this.plot().defaultYMin()).append((Object)"\n").toString());
        var1_1.append(new StringBuilder().append(this.plot().defaultYMax()).append((Object)"\n").toString());
        var1_1.append(Predef$.MODULE$.any2stringadd(BoxesRunTime.boxToBoolean(this.plot().defaultAutoPlotOn())).$plus("\n"));
        var1_1.append(Predef$.MODULE$.any2stringadd(BoxesRunTime.boxToBoolean(this.legend().open())).$plus("\n"));
        var1_1.append(new StringBuilder().append((Object)this.plot().saveString()).append((Object)"\n").toString());
        var1_1.append("PENS\n");
        this.savePens(var1_1);
        return var1_1.toString();
    }

    public void savePens(StringBuilder stringBuilder) {
        this.plot().pens().withFilter((Function1<PlotPen, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(PlotPen plotPen) {
                return !plotPen.temporary();
            }

            public final /* synthetic */ Object apply(Object object) {
                return BoxesRunTime.boxToBoolean(this.apply((PlotPen)object));
            }
        })).foreach(new Serializable(this, stringBuilder){
            public static final long serialVersionUID;
            private final StringBuilder s$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final StringBuilder apply(PlotPen plotPen) {
                return this.s$1.append(new StringBuilder().append((Object)"\"").append((Object)StringUtils$.MODULE$.escapeString(plotPen.name())).append((Object)"\" ").append(BoxesRunTime.boxToDouble(plotPen.defaultInterval())).append((Object)" ").append(BoxesRunTime.boxToInteger(plotPen.defaultMode())).append((Object)" ").append(BoxesRunTime.boxToInteger(plotPen.defaultColor())).append((Object)" ").append(BoxesRunTime.boxToBoolean(plotPen.inLegend())).append((Object)" ").append((Object)plotPen.saveString()).append((Object)"\n").toString());
            }
            {
                this.s$1 = stringBuilder;
            }
        });
    }

    @Override
    public Object load(String[] stringArray, Widget.LoadHelper loadHelper2) {
        List list = Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])stringArray).drop(1)).take(4)).map(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(String string) {
                return Predef$.MODULE$.augmentString(string).toInt();
            }

            public final /* synthetic */ Object apply(Object object) {
                return BoxesRunTime.boxToInteger(this.apply((String)object));
            }
        }, Array$.MODULE$.canBuildFrom(Manifest$.MODULE$.Int()))).toList();
        if (list instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list;
            if ($colon$colon != null) {
                int n = BoxesRunTime.unboxToInt($colon$colon.hd$1());
                List list2 = $colon$colon.tl$1();
                if (list2 instanceof $colon$colon) {
                    $colon$colon $colon$colon2 = ($colon$colon)list2;
                    int n2 = BoxesRunTime.unboxToInt($colon$colon2.hd$1());
                    List list3 = $colon$colon2.tl$1();
                    if (list3 instanceof $colon$colon) {
                        $colon$colon $colon$colon3 = ($colon$colon)list3;
                        int n3 = BoxesRunTime.unboxToInt($colon$colon3.hd$1());
                        List list4 = $colon$colon3.tl$1();
                        if (list4 instanceof $colon$colon) {
                            $colon$colon $colon$colon4 = ($colon$colon)list4;
                            int n4 = BoxesRunTime.unboxToInt($colon$colon4.hd$1());
                            Nil$ nil$ = Nil$.MODULE$;
                            List list5 = $colon$colon4.tl$1();
                            if (!(nil$ != null ? !((Object)nil$).equals(list5) : list5 != null)) {
                                Tuple4<Integer, Integer, Integer, Integer> tuple4 = new Tuple4<Integer, Integer, Integer, Integer>(BoxesRunTime.boxToInteger(n), BoxesRunTime.boxToInteger(n2), BoxesRunTime.boxToInteger(n3), BoxesRunTime.boxToInteger(n4));
                                int n5 = BoxesRunTime.unboxToInt(tuple4._1());
                                int n6 = BoxesRunTime.unboxToInt(tuple4._2());
                                int n7 = BoxesRunTime.unboxToInt(tuple4._3());
                                int n8 = BoxesRunTime.unboxToInt(tuple4._4());
                                this.setSize(n7 - n5, n8 - n6);
                                if (7 < stringArray.length) {
                                    String string = stringArray[6];
                                    String string2 = "NIL";
                                    this.xLabel(!(string != null ? !string.equals(string2) : string2 != null) ? "" : stringArray[6]);
                                    String string3 = stringArray[7];
                                    String string4 = "NIL";
                                    this.yLabel(!(string3 != null ? !string3.equals(string4) : string4 != null) ? "" : stringArray[7]);
                                }
                                if (13 < stringArray.length) {
                                    this.legend().open_$eq(Predef$.MODULE$.augmentString(stringArray[13]).toBoolean());
                                }
                                PlotLoader$.MODULE$.parsePlot(stringArray, this.plot(), (Function1<String, String>)((Object)new Serializable(this, loadHelper2){
                                    public static final long serialVersionUID;
                                    private final Widget.LoadHelper helper$1;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply(String string) {
                                        return this.helper$1.convert(string, false);
                                    }
                                    {
                                        this.helper$1 = loadHelper2;
                                    }
                                }));
                                this.plotName(this.plot().name());
                                this.clear();
                                return this;
                            }
                            throw new MatchError(list);
                        }
                        throw new MatchError(list);
                    }
                    throw new MatchError(list);
                }
                throw new MatchError(list);
            }
            throw new MatchError(list);
        }
        throw new MatchError(list);
    }

    public BufferedImage exportGraphics() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.paint(bufferedImage.getGraphics());
        return bufferedImage;
    }

    private void recolor() {
        this.nameLabel().setForeground(this.anyErrors() ? Color.RED : Color.BLACK);
    }

    @Override
    public void handle(Events.AfterLoadEvent afterLoadEvent) {
        this.plotManager().compilePlot(this.plot());
        this.recolor();
    }

    @Override
    public void handle(Events.WidgetRemovedEvent widgetRemovedEvent) {
        Widget widget = widgetRemovedEvent.widget;
        AbstractPlotWidget abstractPlotWidget = this;
        if (!(widget != null ? !widget.equals(abstractPlotWidget) : abstractPlotWidget != null)) {
            this.plotManager().forgetPlot(this.plot());
        }
    }

    @Override
    public void handle(Events.CompiledEvent compiledEvent) {
        if (compiledEvent.sourceOwner instanceof ProceduresInterface) {
            this.plotManager().compilePlot(this.plot());
            this.recolor();
        }
    }

    @Override
    public boolean anyErrors() {
        return this.plotManager().hasErrors(this.plot());
    }

    @Override
    public Exception error(Object object) {
        Object object2;
        block4: {
            Option<CompilerException> option;
            block3: {
                block2: {
                    Object object3 = object2 = object;
                    String string = "setupCode";
                    if (object3 != null ? !object3.equals(string) : string != null) break block2;
                    option = this.plotManager().getPlotSetupError(this.plot());
                    break block3;
                }
                Object object4 = object2;
                String string = "updateCode";
                if (object4 != null ? !object4.equals(string) : string != null) break block4;
                option = this.plotManager().getPlotUpdateError(this.plot());
            }
            return (Exception)option.orNull(Predef$.MODULE$.conforms());
        }
        throw new MatchError(object2);
    }

    @Override
    public void error(Object object, Exception exception) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean editFinished() {
        super.editFinished();
        this.plotManager().compilePlot(this.plot());
        this.nameLabel().setText(this.plot().name());
        this.xAxis().setLabel(this._xAxisLabel());
        this.yAxis().setLabel(this._yAxisLabel());
        this.recolor();
        this.legend().refresh();
        return true;
    }

    private final String getLabel$1(double d) {
        return ((Object)BoxesRunTime.boxToDouble(d)).toString().endsWith(".0") ? (String)Predef$.MODULE$.augmentString(((Object)BoxesRunTime.boxToDouble(d)).toString()).dropRight(2) : ((Object)BoxesRunTime.boxToDouble(d)).toString();
    }

    public AbstractPlotWidget(Plot plot2, PlotManagerInterface plotManagerInterface) {
        this.plot = plot2;
        this.plotManager = plotManagerInterface;
        this.fullyConstructed = false;
        this.bitmap$init$0 |= 1;
        plot2.dirtyListener_$eq(new Some<Plot.DirtyListener>(this));
        this.canvas = new PlotCanvas(plot2);
        this.bitmap$init$0 |= 2;
        this.legend = new PlotLegend(plot2, this);
        this.bitmap$init$0 |= 4;
        this.nameLabel = new JLabel("", 0);
        this.bitmap$init$0 |= 8;
        this.xAxis = new XAxisLabels();
        this.bitmap$init$0 |= 0x10;
        this.yAxis = new YAxisLabels();
        this.bitmap$init$0 |= 0x20;
        this.displayName_$eq(plot2.name());
        this.setBorder(this.widgetBorder());
        this.setOpaque(true);
        Fonts$.MODULE$.adjustDefaultFont(this);
        this.setBackground(InterfaceColors.PLOT_BACKGROUND);
        plot2.clear();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.nameLabel(), gridBagConstraints);
        this.add(this.nameLabel());
        Fonts$.MODULE$.adjustDefaultFont(this.nameLabel());
        this.nameLabel().setFont(this.nameLabel().getFont().deriveFont(1));
        this.nameLabel().setText(plot2.name());
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.weighty = 3.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 3;
        gridBagLayout.setConstraints(this.yAxis(), gridBagConstraints);
        this.add(this.yAxis());
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.canvas(), gridBagConstraints);
        this.add(this.canvas());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 1);
        gridBagLayout.setConstraints(this.legend(), gridBagConstraints);
        this.add(this.legend());
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 2;
        JLabel jLabel = new JLabel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.xAxis(), gridBagConstraints);
        this.add(this.xAxis());
        JLabel jLabel2 = new JLabel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        this.add(jLabel2);
        this.refreshGUI();
        Predef$.MODULE$.locally(BoxedUnit.UNIT);
        this._xAxisLabel = "";
        this.bitmap$init$0 |= 0x40;
        this._yAxisLabel = "";
        this.bitmap$init$0 |= 0x80;
        this.fullyConstructed_$eq(true);
    }

    public static class XAxisLabels
    extends JPanel
    implements ScalaObject {
        private final JLabel min = new JLabel();
        private final JLabel label;
        private final JLabel max;
        private final GridBagLayout gridbag;
        private final GridBagConstraints c;
        private volatile int bitmap$init$0;

        private JLabel min() {
            if ((this.bitmap$init$0 & 1) != 0) {
                return this.min;
            }
            throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 319".toString());
        }

        private JLabel label() {
            if ((this.bitmap$init$0 & 2) != 0) {
                return this.label;
            }
            throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 320".toString());
        }

        private JLabel max() {
            if ((this.bitmap$init$0 & 4) != 0) {
                return this.max;
            }
            throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 321".toString());
        }

        public GridBagLayout gridbag() {
            if ((this.bitmap$init$0 & 8) != 0) {
                return this.gridbag;
            }
            throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 324".toString());
        }

        public GridBagConstraints c() {
            if ((this.bitmap$init$0 & 0x10) != 0) {
                return this.c;
            }
            throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 326".toString());
        }

        public void setLabel(String string) {
            this.label().setText(string);
        }

        public void setMax(String string) {
            this.max().setText(string);
        }

        public void setMin(String string) {
            this.min().setText(string);
        }

        public String getLabel() {
            return this.label().getText();
        }

        public XAxisLabels() {
            this.bitmap$init$0 |= 1;
            this.label = new JLabel("", 0);
            this.bitmap$init$0 |= 2;
            this.max = new JLabel();
            this.bitmap$init$0 |= 4;
            this.setBackground(InterfaceColors.PLOT_BACKGROUND);
            this.gridbag = new GridBagLayout();
            this.bitmap$init$0 |= 8;
            this.setLayout(this.gridbag());
            this.c = new GridBagConstraints();
            this.bitmap$init$0 |= 0x10;
            this.c().insets = new Insets(0, 0, 0, 3);
            this.c().gridheight = 1;
            this.c().weighty = 0.0;
            this.c().fill = 0;
            this.c().gridwidth = 1;
            this.c().weightx = 0.0;
            this.c().anchor = 17;
            this.c().fill = 0;
            this.gridbag().setConstraints(this.min(), this.c());
            this.add(this.min());
            this.c().weightx = 100.0;
            this.c().anchor = 10;
            this.c().fill = 2;
            this.gridbag().setConstraints(this.label(), this.c());
            this.add(this.label());
            this.c().gridwidth = 0;
            this.c().weightx = 0.0;
            this.c().anchor = 13;
            this.c().fill = 0;
            this.gridbag().setConstraints(this.max(), this.c());
            this.add(this.max());
            Fonts$.MODULE$.adjustDefaultFont(this.min());
            Fonts$.MODULE$.adjustDefaultFont(this.label());
            Fonts$.MODULE$.adjustDefaultFont(this.max());
        }
    }

    public static class YAxisLabels
    extends JPanel
    implements ScalaObject {
        private final JLabel label = new JLabel();
        private String labelText;
        private final JLabel max;
        private final VTextIcon labelIcon;
        private final JLabel min;
        private final GridBagLayout gridbag;
        private final GridBagConstraints c;
        private volatile int bitmap$init$0;

        private JLabel label() {
            if ((this.bitmap$init$0 & 1) != 0) {
                return this.label;
            }
            throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 359".toString());
        }

        private String labelText() {
            if ((this.bitmap$init$0 & 2) != 0) {
                return this.labelText;
            }
            throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 360".toString());
        }

        private void labelText_$eq(String string) {
            this.labelText = string;
            this.bitmap$init$0 |= 2;
        }

        private JLabel max() {
            if ((this.bitmap$init$0 & 4) != 0) {
                return this.max;
            }
            throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 361".toString());
        }

        private VTextIcon labelIcon() {
            if ((this.bitmap$init$0 & 8) != 0) {
                return this.labelIcon;
            }
            throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 362".toString());
        }

        private JLabel min() {
            if ((this.bitmap$init$0 & 0x10) != 0) {
                return this.min;
            }
            throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 363".toString());
        }

        public GridBagLayout gridbag() {
            if ((this.bitmap$init$0 & 0x20) != 0) {
                return this.gridbag;
            }
            throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 367".toString());
        }

        public GridBagConstraints c() {
            if ((this.bitmap$init$0 & 0x40) != 0) {
                return this.c;
            }
            throw new UninitializedFieldError("Uninitialized field: AbstractPlotWidget.scala: 369".toString());
        }

        public void setMin(String string) {
            this.min().setText(string);
        }

        public void setMax(String string) {
            this.max().setText(string);
        }

        public String getLabel() {
            return this.labelText();
        }

        public void setLabel(String string) {
            this.labelText_$eq(string);
            this.labelIcon().setLabel(this.labelText());
            this.label().repaint();
        }

        public YAxisLabels() {
            this.bitmap$init$0 |= 1;
            this.labelText = "";
            this.bitmap$init$0 |= 2;
            this.max = new JLabel();
            this.bitmap$init$0 |= 4;
            this.labelIcon = new VTextIcon(this.label(), "", VTextIcon.ROTATE_LEFT);
            this.bitmap$init$0 |= 8;
            this.min = new JLabel();
            this.bitmap$init$0 |= 0x10;
            this.setBackground(InterfaceColors.PLOT_BACKGROUND);
            this.label().setIcon(this.labelIcon());
            this.gridbag = new GridBagLayout();
            this.bitmap$init$0 |= 0x20;
            this.setLayout(this.gridbag());
            this.c = new GridBagConstraints();
            this.bitmap$init$0 |= 0x40;
            this.c().insets = new Insets(3, 0, 0, 0);
            this.c().gridwidth = 0;
            this.c().gridheight = 1;
            this.c().weightx = 1.0;
            this.c().weighty = 0.0;
            this.c().anchor = 13;
            this.c().fill = 0;
            this.gridbag().setConstraints(this.max(), this.c());
            this.add(this.max());
            this.c().weighty = 100.0;
            this.c().fill = 3;
            this.gridbag().setConstraints(this.label(), this.c());
            this.add(this.label());
            this.c().gridheight = 0;
            this.c().weighty = 0.0;
            this.c().fill = 0;
            this.gridbag().setConstraints(this.min(), this.c());
            this.add(this.min());
            Fonts$.MODULE$.adjustDefaultFont(this.min());
            Fonts$.MODULE$.adjustDefaultFont(this.label());
            Fonts$.MODULE$.adjustDefaultFont(this.max());
        }
    }
}

