/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.api.I18N;
import org.nlogo.awt.Tree;
import org.nlogo.shape.VectorShape;
import org.nlogo.swing.ColorSwatch;
import org.nlogo.swing.Utils;

public strictfp class ColorDialog
extends JDialog
implements ClipboardOwner,
ActionListener,
ItemListener,
MouseListener,
WindowListener {
    private double step = 1.0;
    private boolean numberVisibilityFlag = false;
    private boolean pointOneStepflag = false;
    private final NumberFormat formatter = new DecimalFormat("###.####");
    private int okCancelFlag = 0;
    private boolean plotPenMode = false;
    private JButton okButton;
    private Color selectedColor;
    private double selectedColorNumber;
    private String selectedColorName;
    private final Container pane;
    private final ButtonGroup swatchesGroup = new ButtonGroup();
    private final Container swatchesContainer = new Container();
    private final Container leftNameContainer = new Container();
    private final Container topNameContainer = new Container();
    private final Container rightPreviewContainer = new Container();
    private JRadioButton oneStep;
    private JRadioButton pointFiveStep;
    private JRadioButton pointOneStep;
    private ImageIcon turtleIcon;
    private JCheckBox checkboxHideNumbers;
    private JLabel selectedColorLabel;
    private JLabel[] turtleLabel = new JLabel[16];

    public ColorDialog(Frame frame, boolean bl) {
        super(frame, I18N.guiJ().get("tools.colorswatch"), bl);
        this.setVisible(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(600, 400);
        this.setDefaultCloseOperation(1);
        this.pane = this.getContentPane();
        this.turtleIcon = this.getShapeIcon(0.0);
        this.addWindowListener(this);
        this.createLeftNames();
        this.createTopNames(this.turtleIcon);
        this.createRightPreview(this.turtleIcon);
        this.createTopLeftLabel();
        this.createSwatches();
        Utils.addEscKeyAction(this, (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorDialog.this.setVisible(false);
                ColorDialog.this.dispose();
            }
        });
    }

    public double showInputBoxDialog(double d) {
        this.plotPenMode = true;
        this.createControls(this.plotPenMode);
        this.selectSwatch(org.nlogo.api.Color.getColor(d));
        this.workAroundQuaquaBug(this);
        this.setVisible(true);
        if (this.okCancelFlag == 1) {
            return this.selectedColorNumber;
        }
        return d;
    }

    private void selectSwatch(Color color) {
        double d = org.nlogo.api.Color.getClosestColorNumberByARGB(color.getRGB());
        Color color2 = new Color(org.nlogo.api.Color.getARGBbyPremodulatedColorNumber(d));
        if (d % 1.0 == 0.0 || d >= 9.9) {
            this.oneStep.doClick();
        } else if (d % 5.0 == 0.0) {
            this.pointOneStep.doClick();
        } else {
            this.pointFiveStep.doClick();
        }
        Enumeration<AbstractButton> enumeration = this.swatchesGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JToggleButton jToggleButton = (JToggleButton)enumeration.nextElement();
            Color color3 = jToggleButton.getBackground();
            if (!color2.equals(color3)) continue;
            jToggleButton.doClick();
        }
    }

    private void createTopNames(ImageIcon imageIcon) {
        this.topNameContainer.setLayout(new GridLayout());
        Container container = new Container();
        container.setLayout(new GridLayout(1, 3));
        this.turtleLabel[14] = new JLabel(imageIcon, 0);
        this.turtleLabel[14].setPreferredSize(new Dimension(60, 20));
        this.turtleLabel[14].setBackground(new Color(0, 0, 0));
        this.turtleLabel[14].setOpaque(true);
        container.add(this.turtleLabel[14]);
        JToggleButton jToggleButton = new JToggleButton(org.nlogo.api.Color.getColorNameByIndex(14) + " = 0");
        jToggleButton.addActionListener(this);
        jToggleButton.setActionCommand("0.0");
        jToggleButton.setOpaque(true);
        jToggleButton.setFont(new Font("ArialNarrow", 0, 10));
        Insets insets = new Insets(0, 0, 0, 0);
        jToggleButton.setMargin(insets);
        this.swatchesGroup.add(jToggleButton);
        container.add(jToggleButton);
        container.add(new JLabel(""));
        this.topNameContainer.add(container);
        Container container2 = new Container();
        container2.setLayout(new GridLayout(1, 3));
        container2.add(new JLabel(""));
        JToggleButton jToggleButton2 = new JToggleButton(org.nlogo.api.Color.getColorNameByIndex(15) + " = 9.9");
        jToggleButton2.addActionListener(this);
        jToggleButton2.setActionCommand("9.9");
        jToggleButton2.setOpaque(true);
        jToggleButton2.setFont(new Font("ArialNarrow", 0, 10));
        jToggleButton2.setMargin(insets);
        this.swatchesGroup.add(jToggleButton2);
        container2.add(jToggleButton2);
        this.turtleLabel[15] = new JLabel(imageIcon, 0);
        this.turtleLabel[15].setPreferredSize(new Dimension(60, 20));
        this.turtleLabel[15].setBackground(new Color(255, 255, 255));
        this.turtleLabel[15].setOpaque(true);
        container2.add(this.turtleLabel[15]);
        this.topNameContainer.add(container2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.pane.add((Component)this.topNameContainer, gridBagConstraints);
        this.getContentPane().validate();
    }

    private void createLeftNames() {
        this.leftNameContainer.setLayout(new GridLayout(14, 1));
        for (int i = 5; i < 140; i += 10) {
            String string = org.nlogo.api.Color.getColorNameByIndex(i / 10) + " = " + i;
            JToggleButton jToggleButton = new JToggleButton(string);
            jToggleButton.addActionListener(this);
            jToggleButton.setActionCommand(String.valueOf(i));
            jToggleButton.setFont(new Font("ArialNarrow", 0, 10));
            this.swatchesGroup.add(jToggleButton);
            this.leftNameContainer.add(jToggleButton);
        }
        this.getContentPane().invalidate();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pane.add((Component)this.leftNameContainer, gridBagConstraints);
    }

    private void createRightPreview(ImageIcon imageIcon) {
        this.rightPreviewContainer.setLayout(new GridLayout(14, 1));
        int n = 0;
        for (int i = 5; i < 140; i += 10) {
            this.turtleLabel[n] = new JLabel(imageIcon, 0);
            this.turtleLabel[n].setBackground(new Color(org.nlogo.api.Color.getARGBbyPremodulatedColorNumber(i)));
            this.turtleLabel[n].setOpaque(true);
            this.rightPreviewContainer.add(this.turtleLabel[n]);
            ++n;
        }
        this.getContentPane().invalidate();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pane.add((Component)this.rightPreviewContainer, gridBagConstraints);
    }

    private void createTopLeftLabel() {
        JLabel jLabel = new JLabel(I18N.guiJ().get("tools.colorswatch.preview"));
        jLabel.setFont(new Font("ArialNarrow", 0, 10));
        jLabel.setPreferredSize(new Dimension(45, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.pane.add((Component)jLabel, gridBagConstraints);
    }

    private void createSwatches() {
        int n = 14;
        double d = 0.0;
        int n2 = 10;
        int n3 = (int)StrictMath.round((double)n2 / this.step);
        this.swatchesContainer.invalidate();
        this.swatchesContainer.setLayout(new GridLayout(14, n3));
        for (int i = 0; i < 14; ++i) {
            d = i * 10;
            for (int j = 0; j < n3 + 1; ++j) {
                JToggleButton jToggleButton = new JToggleButton();
                if (j >= n3) {
                    d = (double)(i * 10) + 9.9;
                } else {
                    jToggleButton.setForeground(Color.BLACK);
                }
                jToggleButton.setRolloverEnabled(true);
                jToggleButton.setBorderPainted(true);
                jToggleButton.setOpaque(true);
                jToggleButton.setFocusPainted(false);
                jToggleButton.setBorder(BorderFactory.createEmptyBorder());
                Color color = new Color(org.nlogo.api.Color.getARGBbyPremodulatedColorNumber(d));
                jToggleButton.setBackground(color);
                ColorSwatch colorSwatch = new ColorSwatch(jToggleButton.getPreferredSize().width, jToggleButton.getPreferredSize().height);
                colorSwatch.setBackground(color);
                if (!this.numberVisibilityFlag && !this.pointOneStepflag) {
                    JLabel jLabel = new JLabel(this.formatter.format(d));
                    jLabel.setFont(new Font("ArialNarrow", 0, 8));
                    if (d % 10.0 < 3.5) {
                        jLabel.setForeground(Color.LIGHT_GRAY);
                    }
                    colorSwatch.add(jLabel);
                }
                jToggleButton.add(colorSwatch);
                jToggleButton.setActionCommand(String.valueOf(d));
                jToggleButton.addActionListener(this);
                jToggleButton.addMouseListener(this);
                this.swatchesGroup.add(jToggleButton);
                this.swatchesContainer.add(jToggleButton);
                d = this.step + d;
            }
        }
        this.swatchesContainer.validate();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 2);
        this.pane.add((Component)this.swatchesContainer, gridBagConstraints);
    }

    private void createControls(boolean bl) {
        JComponent jComponent;
        Container container = new Container();
        container.setLayout(new BoxLayout(container, 2));
        if (!bl) {
            jComponent = new JButton(I18N.guiJ().get("tools.colorswatch.copy"));
            ((AbstractButton)jComponent).setActionCommand("Copy");
            ((AbstractButton)jComponent).addActionListener(this);
            container.add(jComponent);
        } else {
            container.add(Box.createRigidArea(new Dimension(10, 0)));
            this.okButton = new JButton(I18N.guiJ().get("common.buttons.ok"));
            container.add(this.okButton);
            this.okButton.addActionListener(this);
            container.add(Box.createRigidArea(new Dimension(10, 0)));
            jComponent = new JButton(I18N.guiJ().get("common.buttons.cancel"));
            ((AbstractButton)jComponent).addActionListener(this);
            container.add(jComponent);
            container.add(Box.createRigidArea(new Dimension(10, 0)));
        }
        this.selectedColorLabel = new JLabel(org.nlogo.api.Color.getColorNameByIndex(14));
        this.selectedColorLabel.setMinimumSize(new Dimension(100, 20));
        this.selectedColorLabel.setMaximumSize(new Dimension(100, 20));
        this.selectedColorLabel.setPreferredSize(new Dimension(100, 20));
        this.selectedColorLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        container.add(this.selectedColorLabel);
        container.add(Box.createHorizontalGlue());
        this.checkboxHideNumbers = new JCheckBox(I18N.guiJ().get("tools.colorswatch.numbers"), true);
        container.add(this.checkboxHideNumbers);
        this.checkboxHideNumbers.addItemListener(this);
        container.add(Box.createHorizontalGlue());
        jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 2));
        jComponent.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.oneStep = new JRadioButton("1");
        this.oneStep.setActionCommand("oneStep");
        jComponent.add(this.oneStep);
        this.oneStep.setSelected(true);
        this.pointFiveStep = new JRadioButton("0.5");
        this.pointFiveStep.setActionCommand("pointFiveStep");
        jComponent.add(this.pointFiveStep);
        this.pointOneStep = new JRadioButton("0.1");
        this.pointOneStep.setActionCommand("pointOneStep");
        jComponent.add(this.pointOneStep);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.oneStep);
        buttonGroup.add(this.pointFiveStep);
        buttonGroup.add(this.pointOneStep);
        this.oneStep.addActionListener(this);
        this.pointFiveStep.addActionListener(this);
        this.pointOneStep.addActionListener(this);
        container.add(jComponent);
        JLabel jLabel = new JLabel(" " + I18N.guiJ().get("tools.colorswatch.increment"));
        container.add(jLabel);
        container.add(Box.createRigidArea(new Dimension(10, 0)));
        container.add(new JLabel("  "));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        this.pane.add((Component)container, gridBagConstraints);
    }

    private ImageIcon getShapeIcon(double d) {
        VectorShape vectorShape = VectorShape.getDefaultShape();
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        Graphics2DWrapper graphics2DWrapper = new Graphics2DWrapper(bufferedImage.createGraphics());
        graphics2DWrapper.antiAliasing(true);
        vectorShape.paint(graphics2DWrapper, new Color(org.nlogo.api.Color.getARGBbyPremodulatedColorNumber(d)), 0, 0, 16.0, 0);
        graphics2DWrapper.drawImage(bufferedImage);
        return new ImageIcon(bufferedImage);
    }

    private boolean isNumber(String string) {
        try {
            Double.valueOf(string).doubleValue();
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (this.isNumber(string)) {
            this.selectedColorNumber = Double.valueOf(actionEvent.getActionCommand());
            this.selectedColor = new Color(org.nlogo.api.Color.getARGBbyPremodulatedColorNumber(this.selectedColorNumber));
            this.selectedColorName = org.nlogo.api.Color.getClosestColorNameByARGB(this.selectedColor.getRGB());
            this.selectedColorLabel.setText(this.selectedColorName);
            this.turtleIcon = this.getShapeIcon(this.selectedColorNumber);
            for (int i = 0; i <= 15; ++i) {
                this.turtleLabel[i].setIcon(this.turtleIcon);
            }
        } else if (string.equals("Copy")) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            StringSelection stringSelection = new StringSelection(this.selectedColorName);
            Clipboard clipboard = toolkit.getSystemClipboard();
            clipboard.setContents(stringSelection, this);
        } else if (string.endsWith("Step")) {
            if (string.equals("oneStep")) {
                this.step = 1.0;
                this.pointOneStepflag = false;
                this.checkboxHideNumbers.setEnabled(true);
            } else if (string.equals("pointFiveStep")) {
                this.step = 0.5;
                this.pointOneStepflag = false;
                this.checkboxHideNumbers.setEnabled(true);
            } else if (string.equals("pointOneStep")) {
                this.step = 0.1;
                this.pointOneStepflag = true;
                this.checkboxHideNumbers.setEnabled(false);
            }
            this.swatchesContainer.setVisible(false);
            this.swatchesContainer.removeAll();
            this.createSwatches();
            this.swatchesContainer.setVisible(true);
            this.swatchesContainer.repaint();
        } else if (string.equals(I18N.guiJ().get("common.buttons.ok"))) {
            this.okCancelFlag = 1;
            this.dispose();
        } else if (string.equals(I18N.guiJ().get("common.buttons.cancel"))) {
            this.okCancelFlag = -1;
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.numberVisibilityFlag = false;
        } else if (itemEvent.getStateChange() == 2) {
            this.numberVisibilityFlag = true;
        }
        this.swatchesContainer.removeAll();
        this.createSwatches();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        JToggleButton jToggleButton = (JToggleButton)mouseEvent.getSource();
        jToggleButton.setBorder(BorderFactory.createLineBorder(Color.gray));
        if ((mouseEvent.getModifiers() & 0x1F5) == 16) {
            jToggleButton.doClick();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        JToggleButton jToggleButton = (JToggleButton)mouseEvent.getSource();
        jToggleButton.setSelected(false);
        jToggleButton.setBorder(BorderFactory.createEmptyBorder());
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.plotPenMode) {
            this.okCancelFlag = 1;
            this.okButton.doClick();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void workAroundQuaquaBug(Container container) {
        Tree.walkComponentTree(container, 0, new Tree.ComponentTreeWalker(){

            public void touch(Component component, int n) {
                if (component instanceof JComponent) {
                    ((JComponent)component).putClientProperty("Quaqua.Button.style", "toggle");
                }
            }
        });
    }
}

