/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.CompilerException;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.api.Program;
import org.nlogo.api.ValueConstraint;
import org.nlogo.nvm.CompilerResults;
import org.nlogo.nvm.Procedure;
import org.nlogo.util.Exceptions;
import org.nlogo.window.Event;
import org.nlogo.window.Events;
import org.nlogo.window.ExternalFileInterface;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.InterfaceGlobalWidget;
import org.nlogo.window.JobWidget;
import org.nlogo.window.ProceduresInterface;
import org.nlogo.window.Widget;
import org.nlogo.workspace.AbstractWorkspace;
import scala.Some;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CompilerManager
implements Event.LinkChild,
Events.CompileAllEvent.Handler,
Events.CompileMoreSourceEvent.Handler,
Events.InterfaceGlobalEvent.Handler,
Events.LoadBeginEvent.Handler,
Events.LoadEndEvent.Handler,
Events.WidgetAddedEvent.Handler,
Events.WidgetRemovedEvent.Handler {
    private final GUIWorkspace workspace;
    private final ProceduresInterface proceduresInterface;
    public final Set<JobOwner> widgets = new HashSet<JobOwner>();
    public final Set<InterfaceGlobalWidget> globalWidgets = new HashSet<InterfaceGlobalWidget>();
    private boolean isLoading = false;

    public CompilerManager(GUIWorkspace gUIWorkspace, ProceduresInterface proceduresInterface) {
        this.workspace = gUIWorkspace;
        this.proceduresInterface = proceduresInterface;
    }

    @Override
    public Object getLinkParent() {
        return this.workspace;
    }

    @Override
    public void handle(Events.LoadBeginEvent loadBeginEvent) {
        this.isLoading = true;
        this.widgets.clear();
        this.globalWidgets.clear();
        this.workspace.world.clearLinks();
        this.workspace.world.program(this.workspace.world.newProgram());
        this.workspace.world.rememberOldProgram();
        Program program = this.workspace.world.newProgram();
        this.workspace.world.program(program);
        this.workspace.world.turtleBreedShapes.setUpBreedShapes(true, program.breeds());
        this.workspace.world.linkBreedShapes.setUpBreedShapes(true, program.linkBreeds());
    }

    @Override
    public void handle(Events.LoadEndEvent loadEndEvent) {
        this.isLoading = false;
        this.compileAll();
    }

    private void compileAll() {
        new Events.RemoveAllJobsEvent().raise(this);
        this.workspace.world.displayOn(true);
        if (!this.isLoading) {
            boolean bl = this.compileProcedures();
            if (bl) {
                this.workspace.world.realloc();
                this.workspace.world.rememberOldProgram();
                this.setGlobalVariables();
                this.compileWidgets();
            } else {
                this.updateInterfaceGlobalConstraints();
                this.resetWidgetProcedures();
            }
        }
    }

    private boolean compileProcedures() {
        this.workspace.world.program(this.workspace.world.newProgram());
        try {
            CompilerResults compilerResults = this.workspace.compiler().compileProgram(this.proceduresInterface.innerSource(), this.workspace.world.newProgram(this.getGlobalVariableNames()), this.workspace.getExtensionManager());
            this.workspace.setProcedures(compilerResults.proceduresMap());
            for (Procedure procedure : this.workspace.getProcedures().values()) {
                if (procedure.fileName.equals("")) {
                    procedure.setOwner(this.proceduresInterface);
                    continue;
                }
                if (procedure.fileName.equals("aggregate")) {
                    procedure.setOwner(this.workspace.aggregateManager());
                    continue;
                }
                procedure.setOwner(new ExternalFileInterface(procedure.fileName));
            }
            this.workspace.init();
            this.workspace.world.program(compilerResults.program());
            new Events.CompiledEvent(this.proceduresInterface, compilerResults.program(), null, null).raise(this);
            return true;
        }
        catch (CompilerException compilerException) {
            if (AbstractWorkspace.isApplet()) {
                System.err.println("CompilerException: " + compilerException);
                compilerException.printStackTrace();
                new Events.CompiledEvent(this.proceduresInterface, null, null, compilerException).raise(this);
            }
            if (compilerException.fileName().equals("")) {
                new Events.CompiledEvent(this.proceduresInterface, null, null, compilerException).raise(this);
            } else if (compilerException.fileName().equals("aggregate")) {
                new Events.CompiledEvent(this.workspace.aggregateManager(), null, null, compilerException).raise(this);
            } else {
                new Events.CompiledEvent(new ExternalFileInterface(compilerException.fileName()), null, null, compilerException).raise(this);
            }
            return false;
        }
    }

    private void setGlobalVariables() {
        for (InterfaceGlobalWidget interfaceGlobalWidget : this.globalWidgets) {
            try {
                this.workspace.world.setObserverVariableByName(interfaceGlobalWidget.name(), interfaceGlobalWidget.valueObject());
            }
            catch (AgentException agentException) {
                throw new IllegalStateException(agentException);
            }
            catch (LogoException logoException) {
                throw new IllegalStateException(logoException);
            }
        }
    }

    private void updateInterfaceGlobalConstraints() {
        for (InterfaceGlobalWidget interfaceGlobalWidget : this.globalWidgets) {
            interfaceGlobalWidget.updateConstraints();
        }
    }

    private void compileSource(JobOwner jobOwner, List<Events.CompiledEvent> list) {
        try {
            CompilerResults compilerResults = this.workspace.compiler().compileMoreCode(jobOwner.source(), Some.apply(jobOwner.classDisplayName() + " '" + jobOwner.displayName() + "'"), this.workspace.world.program(), this.workspace.getProcedures(), this.workspace.getExtensionManager());
            if (!compilerResults.procedures().isEmpty()) {
                compilerResults.head().init(this.workspace);
                compilerResults.head().setOwner(jobOwner);
                new Events.CompiledEvent(jobOwner, this.workspace.world.program(), compilerResults.head(), null).raise(this);
            }
        }
        catch (CompilerException compilerException) {
            list.add(new Events.CompiledEvent(jobOwner, this.workspace.world.program(), null, compilerException));
        }
    }

    private void compileWidgets() {
        ArrayList<Events.CompiledEvent> arrayList = new ArrayList<Events.CompiledEvent>();
        Iterator<JobOwner> iterator2 = this.widgets.iterator();
        if (!iterator2.hasNext()) {
            new Events.CompiledEvent(null, this.workspace.world.program(), null, null).raise(this);
        }
        while (iterator2.hasNext()) {
            JobOwner jobOwner = iterator2.next();
            if (jobOwner.isCommandCenter()) continue;
            this.compileSource(jobOwner, arrayList);
        }
        for (Events.CompiledEvent compiledEvent : arrayList) {
            compiledEvent.raise(this);
        }
        this.updateInterfaceGlobalConstraints();
    }

    private void resetWidgetProcedures() {
        for (JobOwner jobOwner : this.widgets) {
            if (!(jobOwner instanceof JobWidget)) continue;
            ((JobWidget)jobOwner).procedure(null);
        }
    }

    @Override
    public void handle(Events.CompileMoreSourceEvent compileMoreSourceEvent) {
        JobOwner jobOwner = compileMoreSourceEvent.owner;
        if (this.isLoading) {
            this.widgets.add(jobOwner);
            return;
        }
        if (jobOwner.isCommandCenter()) {
            try {
                CompilerResults compilerResults = this.workspace.compiler().compileMoreCode(jobOwner.source(), Some.apply(jobOwner.classDisplayName()), this.workspace.world.program(), this.workspace.getProcedures(), this.workspace.getExtensionManager());
                compilerResults.head().init(this.workspace);
                compilerResults.head().setOwner(jobOwner);
                new Events.CompiledEvent(jobOwner, this.workspace.world.program(), compilerResults.head(), null).raise(this);
            }
            catch (CompilerException compilerException) {
                new Events.CompiledEvent(jobOwner, this.workspace.world.program(), null, compilerException).raise(this);
            }
        } else {
            this.compileWidgets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Events.InterfaceGlobalEvent interfaceGlobalEvent) {
        block11: {
            InterfaceGlobalWidget interfaceGlobalWidget = interfaceGlobalEvent.widget;
            this.globalWidgets.add(interfaceGlobalEvent.widget);
            if (interfaceGlobalEvent.nameChanged) {
                this.compileAll();
            } else if (this.workspace.world.observerOwnsIndexOf(interfaceGlobalWidget.name().toUpperCase()) != -1) {
                if (interfaceGlobalEvent.updating) {
                    interfaceGlobalWidget.valueObject(this.workspace.world.getObserverVariableByName(interfaceGlobalWidget.name()));
                }
                try {
                    Object object = interfaceGlobalWidget.valueObject();
                    if (object == this.workspace.world.getObserverVariableByName(interfaceGlobalWidget.name())) break block11;
                    World world = this.workspace.world;
                    synchronized (world) {
                        this.workspace.world.setObserverVariableByName(interfaceGlobalWidget.name(), interfaceGlobalWidget.valueObject());
                    }
                }
                catch (ValueConstraint.Violation violation) {
                    Exceptions.ignore(violation);
                }
                catch (AgentException agentException) {
                    throw new IllegalStateException(agentException);
                }
                catch (LogoException logoException) {
                    Exceptions.ignore(logoException);
                }
            }
        }
    }

    @Override
    public void handle(Events.WidgetAddedEvent widgetAddedEvent) {
        Widget widget = widgetAddedEvent.widget;
        if (widget instanceof JobOwner) {
            this.widgets.add((JobOwner)((Object)widget));
        }
        if (widget instanceof InterfaceGlobalWidget) {
            this.globalWidgets.add((InterfaceGlobalWidget)((Object)widget));
        }
    }

    @Override
    public void handle(Events.CompileAllEvent compileAllEvent) {
        this.compileAll();
    }

    @Override
    public void handle(Events.WidgetRemovedEvent widgetRemovedEvent) {
        this.widgets.remove(widgetRemovedEvent.widget);
        this.globalWidgets.remove(widgetRemovedEvent.widget);
    }

    private List<String> getGlobalVariableNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (InterfaceGlobalWidget interfaceGlobalWidget : this.globalWidgets) {
            arrayList.add(interfaceGlobalWidget.name());
        }
        return arrayList;
    }
}

