/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.ModelReader;
import org.nlogo.api.ModelSectionJ;
import org.nlogo.api.RandomServices;
import org.nlogo.api.Version;
import org.nlogo.api.VersionHistory;
import org.nlogo.plot.PlotManager;
import org.nlogo.util.Exceptions;
import org.nlogo.util.SysInfo;
import org.nlogo.window.ButtonWidget;
import org.nlogo.window.ChooserWidget;
import org.nlogo.window.EditorFactory;
import org.nlogo.window.Events;
import org.nlogo.window.InputBoxWidget;
import org.nlogo.window.MonitorWidget;
import org.nlogo.window.OutputWidget;
import org.nlogo.window.PlotWidget;
import org.nlogo.window.SliderWidget;
import org.nlogo.window.ViewWidgetInterface;
import org.nlogo.window.Widget;
import org.nlogo.window.WidgetContainer;
import org.nlogo.window.WidgetRegistry;

public strictfp class InterfacePanelLite
extends JLayeredPane
implements FocusListener,
Events.LoadSectionEvent.Handler,
Events.OutputEvent.Handler,
WidgetContainer {
    private final Map<String, Widget> widgets;
    private final ViewWidgetInterface viewWidget;
    private final CompilerServices compiler;
    private final RandomServices random;
    private final PlotManager plotManager;
    private final EditorFactory editorFactory;
    boolean hasFocus = true;
    private boolean sliderEventOnReleaseOnly = false;

    public InterfacePanelLite(ViewWidgetInterface viewWidgetInterface, CompilerServices compilerServices, RandomServices randomServices, PlotManager plotManager, EditorFactory editorFactory) {
        this.viewWidget = viewWidgetInterface;
        this.compiler = compilerServices;
        this.random = randomServices;
        this.plotManager = plotManager;
        this.editorFactory = editorFactory;
        this.widgets = new HashMap<String, Widget>();
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.addFocusListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    InterfacePanelLite.this.doPopup(mouseEvent);
                } else {
                    InterfacePanelLite.this.requestFocus();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    InterfacePanelLite.this.doPopup(mouseEvent);
                }
            }
        });
        this.addKeyListener(this.getKeyAdapter());
        this.addWidget((Widget)((Object)viewWidgetInterface), 0, 0);
    }

    protected KeyAdapter getKeyAdapter() {
        return new ButtonKeyAdapter();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        this.enableButtonKeys(true);
    }

    public void requestFocus() {
        this.requestFocusInWindow();
    }

    public void reset() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof PlotWidget) {
                this.plotManager.forgetPlot(((PlotWidget)componentArray[i]).plot());
            }
            if (componentArray[i] instanceof ViewWidgetInterface) continue;
            this.remove(componentArray[i]);
        }
    }

    private void enableButtonKeys(boolean bl) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof ButtonWidget)) continue;
            ButtonWidget buttonWidget = (ButtonWidget)componentArray[i];
            buttonWidget.keyEnabled(bl);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        this.enableButtonKeys(false);
    }

    protected ButtonWidget findActionButton(char c) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            ButtonWidget buttonWidget;
            if (!(componentArray[i] instanceof ButtonWidget) || Character.toUpperCase((buttonWidget = (ButtonWidget)componentArray[i]).actionKey()) != Character.toUpperCase(c)) continue;
            return buttonWidget;
        }
        return null;
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Widget)) continue;
            Point point = componentArray[i].getLocation();
            Dimension dimension = componentArray[i].getSize();
            int n3 = point.x + dimension.width;
            int n4 = point.y + dimension.height;
            if (n3 > n) {
                n = n3;
            }
            if (n4 <= n2) continue;
            n2 = n4;
        }
        return new Dimension(n, n2);
    }

    private OutputWidget getOutputWidget() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof OutputWidget)) continue;
            return (OutputWidget)componentArray[i];
        }
        return null;
    }

    public void handle(Events.OutputEvent outputEvent) {
        if (this.getOutputWidget() != null && !outputEvent.toCommandCenter) {
            if (outputEvent.clear) {
                this.getOutputWidget().outputArea().clear();
            }
            if (outputEvent.outputObject != null) {
                this.getOutputWidget().outputArea().append(outputEvent.outputObject, outputEvent.wrapLines);
            }
        }
    }

    public String getBoundsString(Widget widget) {
        StringBuilder stringBuilder = new StringBuilder();
        Rectangle rectangle = this.getUnzoomedBounds(widget);
        stringBuilder.append(rectangle.x + "\n");
        stringBuilder.append(rectangle.y + "\n");
        stringBuilder.append(rectangle.x + rectangle.width + "\n");
        stringBuilder.append(rectangle.y + rectangle.height + "\n");
        return stringBuilder.toString();
    }

    public Rectangle getUnzoomedBounds(Component component) {
        return component.getBounds();
    }

    public void resetZoomInfo(Widget widget) {
    }

    public void resetSizeInfo(Widget widget) {
    }

    public boolean isZoomed() {
        return false;
    }

    private void doPopup(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(Version.version());
        jMenuItem.setEnabled(false);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(SysInfo.getOSInfoString());
        jMenuItem.setEnabled(false);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(SysInfo.getVMInfoString());
        jMenuItem.setEnabled(false);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(SysInfo.getMemoryInfoString());
        jMenuItem.setEnabled(false);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    private void addWidget(Widget widget, int n, int n2) {
        this.widgets.put(widget.displayName(), widget);
        widget.addPopupListeners();
        this.add((Component)widget, DEFAULT_LAYER);
        this.moveToFront(widget);
        widget.setLocation(n, n2);
        widget.validate();
    }

    public Widget loadWidget(String[] stringArray, final String string) {
        Widget.LoadHelper loadHelper2 = new Widget.LoadHelper(){

            public String version() {
                return string;
            }

            public String convert(String string2, boolean bl) {
                return InterfacePanelLite.this.compiler.autoConvert(string2, true, bl, string);
            }
        };
        try {
            String string2 = stringArray[0];
            int n = Integer.parseInt(stringArray[1]);
            int n2 = Integer.parseInt(stringArray[2]);
            if (!string2.equals("GRAPHICS-WINDOW") && VersionHistory.olderThan13pre1(string)) {
                n2 += this.viewWidget.getAdditionalHeight();
            }
            if (string2.equals("GRAPHICS-WINDOW") || string2.equals("VIEW")) {
                try {
                    this.viewWidget.asWidget().load(stringArray, loadHelper2);
                }
                catch (RuntimeException runtimeException) {
                    Exceptions.handle(runtimeException);
                }
                this.viewWidget.asWidget().setSize(this.viewWidget.asWidget().getSize());
                this.viewWidget.asWidget().setLocation(n, n2);
                return this.viewWidget.asWidget();
            }
            Widget widget = WidgetRegistry.apply(string2);
            try {
                if (string2.equals("MONITOR")) {
                    widget = new MonitorWidget(this.random.auxRNG());
                } else if (string2.equals("PLOT")) {
                    widget = PlotWidget.apply(this.plotManager);
                } else if (string2.equals("SLIDER")) {
                    widget = new SliderWidget(this.sliderEventOnReleaseOnly, this.random.auxRNG());
                } else if (string2.equals("CHOOSER") || string2.equals("CHOICE")) {
                    widget = new ChooserWidget(this.compiler);
                } else if (string2.equals("INPUTBOX")) {
                    widget = new InputBoxWidget(this.editorFactory.newEditor(1, 20, false), this.editorFactory.newEditor(5, 20, true), this.compiler, this);
                } else if (string2.equals("BUTTON")) {
                    widget = new ButtonWidget(this.random.mainRNG());
                } else if (string2.equals("OUTPUT")) {
                    widget = new OutputWidget();
                }
            }
            catch (RuntimeException runtimeException) {
                Exceptions.handle(runtimeException);
            }
            if (widget != null) {
                widget.load(stringArray, loadHelper2);
                this.addWidget(widget, n, n2);
            }
            return widget;
        }
        catch (RuntimeException runtimeException) {
            Exceptions.handle(runtimeException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Events.LoadSectionEvent loadSectionEvent) {
        if (loadSectionEvent.section == ModelSectionJ.WIDGETS()) {
            try {
                List<List<String>> list = ModelReader.parseWidgets(loadSectionEvent.lines);
                if (null != list) {
                    this.setVisible(false);
                    for (List<String> list2 : list) {
                        String[] stringArray = list2.toArray(new String[list2.size()]);
                        this.loadWidget(stringArray, loadSectionEvent.version);
                    }
                }
            }
            finally {
                this.setVisible(true);
                this.revalidate();
            }
        }
    }

    protected strictfp class ButtonKeyAdapter
    extends KeyAdapter {
        protected ButtonKeyAdapter() {
        }

        protected boolean keyIsHandleable(KeyEvent keyEvent) {
            return keyEvent.getKeyChar() != '\uffff' && !keyEvent.isActionKey() && (keyEvent.getModifiers() & InterfacePanelLite.this.getToolkit().getMenuShortcutKeyMask()) == 0;
        }

        public void keyTyped(KeyEvent keyEvent) {
            ButtonWidget buttonWidget;
            if (this.keyIsHandleable(keyEvent) && (buttonWidget = InterfacePanelLite.this.findActionButton(keyEvent.getKeyChar())) != null) {
                this.buttonKeyed(buttonWidget);
            }
        }

        public void buttonKeyed(ButtonWidget buttonWidget) {
            buttonWidget.keyTriggered();
        }
    }
}

