/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import org.nlogo.api.Approximate;
import org.nlogo.plot.Plot;
import org.nlogo.plot.PlotPainter;
import org.nlogo.window.InterfaceColors;

strictfp class PlotCanvas
extends JPanel {
    final Plot plot;
    private final PlotPainter painter;
    public boolean dirty = true;
    private boolean mouseHere = false;
    private Point mouseLoc = null;
    private final MouseListener mouseListener = new MouseAdapter(){

        public void mouseEntered(MouseEvent mouseEvent) {
            PlotCanvas.this.mouseHere = true;
            PlotCanvas.this.mouseLoc = mouseEvent.getPoint();
            PlotCanvas.this.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            PlotCanvas.this.mouseHere = false;
            PlotCanvas.this.repaint();
        }
    };
    private final MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        public void mouseDragged(MouseEvent mouseEvent) {
            PlotCanvas.this.mouseLoc = mouseEvent.getPoint();
            PlotCanvas.this.mouseHere = ((PlotCanvas)PlotCanvas.this).mouseLoc.x >= 0 && ((PlotCanvas)PlotCanvas.this).mouseLoc.y >= 0 && ((PlotCanvas)PlotCanvas.this).mouseLoc.x < PlotCanvas.this.getBounds().width && ((PlotCanvas)PlotCanvas.this).mouseLoc.y < PlotCanvas.this.getBounds().height;
            PlotCanvas.this.repaint();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            PlotCanvas.this.mouseHere = true;
            PlotCanvas.this.mouseLoc = mouseEvent.getPoint();
            PlotCanvas.this.repaint();
        }
    };

    void repaintIfNeeded() {
        if (this.dirty) {
            this.painter.setupOffscreenImage(this.getWidth(), this.getHeight());
            this.painter.refresh();
            this.dirty = false;
            this.repaint();
        }
    }

    public void makeDirty() {
        this.dirty = true;
    }

    PlotCanvas(Plot plot2) {
        this.plot = plot2;
        this.painter = new PlotPainter(plot2);
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
    }

    public void paintComponent(Graphics graphics) {
        this.painter.setupOffscreenImage(this.getWidth(), this.getHeight());
        this.painter.drawImage(graphics);
        if (this.mouseHere) {
            this.drawMouseCoords(graphics);
        }
    }

    private void drawMouseCoords(Graphics graphics) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getAscent();
        int n2 = (int)(-StrictMath.floor(StrictMath.log(this.fromScreenXCor(1.0) - this.fromScreenXCor(0.0)) / StrictMath.log(10.0)));
        String string = Double.toString(Approximate.approximate(this.fromScreenXCor(this.mouseLoc.x), n2));
        if (n2 <= 0) {
            string = string.substring(0, string.length() - 2);
        }
        int n3 = fontMetrics.stringWidth(string);
        int n4 = (int)(-StrictMath.floor(StrictMath.log(this.fromScreenYCor(0.0) - this.fromScreenYCor(1.0)) / StrictMath.log(10.0)));
        String string2 = Double.toString(Approximate.approximate(this.fromScreenYCor(this.mouseLoc.y), n4));
        if (n4 <= 0) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        int n5 = fontMetrics.stringWidth(string2);
        int n6 = this.mouseLoc.x - n3 / 2;
        n6 = StrictMath.max(n6, n5);
        n6 = StrictMath.min(n6, this.getBounds().width - n3);
        int n7 = this.getBounds().height - n + 1;
        graphics.setColor(InterfaceColors.PLOT_BACKGROUND);
        graphics.fillRect(n6 - 1, n7, n3 + 1, n + 1);
        graphics.setColor(Color.BLACK);
        graphics.drawString(string, n6, n7 + n - 1);
        int n8 = this.mouseLoc.y - n / 2;
        n8 = StrictMath.max(n8, 0);
        n8 = StrictMath.min(n8, this.getBounds().height - 2 * n);
        int n9 = 0;
        graphics.setColor(InterfaceColors.PLOT_BACKGROUND);
        graphics.fillRect(n9, n8, n5 + 1, n + 1);
        graphics.setColor(Color.BLACK);
        graphics.drawString(string2, n9, n8 + n - 1);
    }

    private double fromScreenXCor(double d) {
        double d2 = this.getWidth() - 1;
        double d3 = this.plot.xMax() - this.plot.xMin();
        return this.plot.xMin() + d * d3 / d2;
    }

    private double fromScreenYCor(double d) {
        double d2 = this.getHeight() - 1;
        double d3 = this.plot.yMax() - this.plot.yMin();
        return this.plot.yMax() - d * d3 / d2;
    }
}

