/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.nlogo.api.I18N;
import org.nlogo.api.Version;
import org.nlogo.awt.Fonts;
import org.nlogo.log.Logger;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;

public strictfp class SpeedSliderPanel
extends JPanel
implements MouseListener,
ChangeListener,
Events.LoadBeginEvent.Handler {
    private final GUIWorkspace workspace;
    final SpeedSlider speedSlider;
    final JLabel normal = new SpeedLabel(I18N.guiJ().get("tabs.run.speedslider.normalspeed"));
    private final boolean labelsBelow;

    public SpeedSliderPanel(GUIWorkspace gUIWorkspace, boolean bl) {
        this.workspace = gUIWorkspace;
        this.labelsBelow = bl;
        this.speedSlider = new SpeedSlider((int)gUIWorkspace.speedSliderPosition());
        this.speedSlider.setFocusable(false);
        this.speedSlider.addChangeListener(this);
        this.speedSlider.addMouseListener(this);
        this.speedSlider.setOpaque(false);
        Fonts.adjustDefaultFont(this.normal);
        this.setOpaque(false);
        if (bl) {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.gridwidth = 0;
            this.add((Component)this.speedSlider, gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 10;
            this.add((Component)this.normal, gridBagConstraints);
        } else {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setVgap(0);
            this.setLayout(borderLayout);
            this.add((Component)this.speedSlider, "Center");
            this.add((Component)this.normal, "East");
        }
        this.enableLabels(0);
    }

    public void setEnabled(boolean bl) {
        this.speedSlider.setEnabled(bl);
        if (bl) {
            this.stateChanged(null);
        } else {
            this.normal.setText(" ");
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.speedSlider.getValue();
        n = n < -10 ? (n += 10) : (n > 10 ? (n -= 10) : 0);
        this.workspace.speedSliderPosition(n / 2);
        if (Version.isLoggingEnabled()) {
            Logger.logSpeedSlider(n);
        }
        this.enableLabels(n);
        this.workspace.updateManager().nudgeSleeper();
    }

    void enableLabels(int n) {
        if (n == 0) {
            if (this.labelsBelow) {
                this.normal.setText("      " + I18N.guiJ().get("tabs.run.speedslider.normalspeed"));
            } else {
                this.normal.setText(I18N.guiJ().get("tabs.run.speedslider.normalspeed"));
            }
        } else if (n < 0) {
            if (this.labelsBelow) {
                this.normal.setText(I18N.guiJ().get("tabs.run.speedslider.slower") + "                         ");
            } else {
                this.normal.setText(I18N.guiJ().get("tabs.run.speedslider.slower"));
            }
        } else if (this.labelsBelow) {
            this.normal.setText("                         " + I18N.guiJ().get("tabs.run.speedslider.faster"));
        } else {
            this.normal.setText(I18N.guiJ().get("tabs.run.speedslider.faster"));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = this.speedSlider.getValue();
        if (n <= 10 && n > 0 || n >= -10 && n < 0) {
            this.speedSlider.setValue(0);
        }
    }

    public void handle(Events.LoadBeginEvent loadBeginEvent) {
        this.speedSlider.reset();
    }

    public boolean isEnabled() {
        return this.speedSlider.isEnabled();
    }

    private strictfp class SpeedLabel
    extends JLabel {
        SpeedLabel(String string) {
            super(string);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            dimension.width = !SpeedSliderPanel.this.labelsBelow ? StrictMath.max(dimension.width, fontMetrics.stringWidth(I18N.guiJ().get("tabs.run.speedslider.normalspeed"))) : StrictMath.max(dimension.width, fontMetrics.stringWidth("                         " + I18N.guiJ().get("tabs.run.speedslider.faster")) + 10);
            return dimension;
        }
    }

    private strictfp class SpeedSlider
    extends JSlider
    implements MouseWheelListener {
        SpeedSlider(int n) {
            super(-110, 112, n);
            this.setExtent(1);
            this.setToolTipText("Adjust speed of model");
            this.addMouseWheelListener(this);
        }

        public Dimension getPreferredSize() {
            return new Dimension(180, super.getPreferredSize().height);
        }

        public Dimension getMinimumSize() {
            return new Dimension(60, super.getPreferredSize().height);
        }

        void reset() {
            this.setValue(0);
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.setValue(this.getValue() - mouseWheelEvent.getWheelRotation());
        }

        public void paint(Graphics graphics) {
            Rectangle rectangle = this.getBounds();
            int n = rectangle.x + rectangle.width / 2 - 1;
            graphics.setColor(Color.gray);
            graphics.drawLine(n, rectangle.y + rectangle.height * 3 / 4, n, rectangle.y + rectangle.height);
            super.paint(graphics);
        }
    }
}

