/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.Perspective;
import org.nlogo.api.PerspectiveJ;
import org.nlogo.api.RendererInterface;
import org.nlogo.api.Shape;
import org.nlogo.api.ViewSettings;
import org.nlogo.awt.Colors;
import org.nlogo.awt.Hierarchy;
import org.nlogo.awt.ImageSelection;
import org.nlogo.shape.VectorShape;
import org.nlogo.util.Exceptions;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.LocalViewInterface;
import org.nlogo.window.ProceduresInterface;
import org.nlogo.window.SyntaxColors;
import org.nlogo.window.ViewMouseHandler;
import org.nlogo.workspace.AbstractWorkspace;

public strictfp class View
extends JComponent
implements ActionListener,
ViewSettings,
Events.CompiledEvent.Handler,
Events.IconifiedEvent.Handler,
Events.LoadBeginEvent.Handler,
Events.LoadEndEvent.Handler,
LocalViewInterface {
    protected final GUIWorkspace workspace;
    final ViewMouseHandler mouser;
    public RendererInterface renderer;
    private boolean paintingImmediately = false;
    private boolean framesSkipped = false;
    private int fontSize = 13;
    private final Runnable paintRunnable = new Runnable(){

        public void run() {
            View.this.paintingImmediately = true;
            View.this.paintImmediately();
            View.this.paintingImmediately = false;
        }
    };
    boolean iconified = false;
    private Image offscreenImage = null;
    private Graphics2D gOff = null;
    private boolean dirty = true;
    public int frameCount = 0;
    private boolean frozen = false;
    protected double patchSize = 13.0;
    private double zoom = 0.0;
    protected double viewWidth;
    protected double viewHeight;
    public boolean renderPerspective = true;

    public View(GUIWorkspace gUIWorkspace) {
        this.workspace = gUIWorkspace;
        this.setOpaque(true);
        this.renderer = gUIWorkspace.newRenderer();
        this.mouser = new ViewMouseHandler(this, gUIWorkspace.world, this);
        this.addMouseListener(this.mouser);
        this.addMouseMotionListener(this.mouser);
        gUIWorkspace.viewManager.add(this);
    }

    public boolean isHeadless() {
        return this.workspace.isHeadless();
    }

    public void displaySwitch(boolean bl) {
        this.workspace.viewWidget.displaySwitch.setOn(bl);
    }

    public boolean displaySwitch() {
        return this.workspace.viewWidget.displaySwitch.isSelected();
    }

    public void incrementalUpdateFromEventThread() {
        this.paintRunnable.run();
    }

    public void dirty() {
        this.dirty = true;
    }

    public void framesSkipped() {
        this.framesSkipped = true;
    }

    public int fontSize() {
        return this.fontSize;
    }

    public void resetMouseCors() {
        this.mouser.resetMouseCors();
    }

    public double mouseXCor() {
        return this.mouser.mouseXCor();
    }

    public double mouseYCor() {
        return this.mouser.mouseYCor();
    }

    public boolean mouseDown() {
        return this.mouser.mouseDown();
    }

    public boolean mouseInside() {
        return this.mouser.mouseInside();
    }

    public void mouseDown(boolean bl) {
        this.mouser.mouseDown(bl);
    }

    public boolean isDead() {
        return false;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.workspace.world.worldWidth(), this.workspace.world.worldHeight());
    }

    public Dimension getPreferredSize() {
        int n = (int)(this.viewWidth * this.patchSize());
        int n2 = (int)(this.viewHeight * this.patchSize());
        return new Dimension(n, n2);
    }

    public void handle(Events.IconifiedEvent iconifiedEvent) {
        if (iconifiedEvent.frame == Hierarchy.getFrame(this)) {
            this.iconified = iconifiedEvent.iconified;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean beClean() {
        if (this.dirty && this.getWidth() > 0 && this.getHeight() > 0) {
            if (this.workspace.jobManager.isInterrupted()) {
                return false;
            }
            if (this.offscreenImage == null) {
                this.offscreenImage = this.createImage(this.getWidth(), this.getHeight());
                if (this.offscreenImage != null) {
                    this.gOff = (Graphics2D)this.offscreenImage.getGraphics();
                    this.gOff.setFont(this.getFont());
                }
            }
            if (this.gOff != null) {
                World world = this.workspace.world;
                synchronized (world) {
                    this.renderer.paint(this.gOff, (ViewSettings)this);
                }
            }
            this.dirty = false;
        }
        return true;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getBounds();
        if (n3 != rectangle.width || n4 != rectangle.height || n != rectangle.x || n2 != rectangle.y) {
            super.setBounds(n, n2, n3, n4);
            this.discardOffscreenImage();
        }
    }

    public void discardOffscreenImage() {
        this.offscreenImage = null;
        this.gOff = null;
        this.dirty = true;
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void paint(Graphics graphics) {
        if (!this.isDead()) {
            this.workspace.updateManager().beginPainting();
            super.paint(graphics);
            this.workspace.updateManager().donePainting();
            if (this.workspace.world.observer().perspective() == PerspectiveJ.FOLLOW() || this.workspace.world.observer().perspective() == PerspectiveJ.RIDE()) {
                this.mouser.updateMouseCors();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        ++this.frameCount;
        if (this.frozen || !this.workspace.world.displayOn()) {
            if (this.dirty) {
                graphics.setColor(InterfaceColors.GRAPHICS_BACKGROUND);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                graphics.drawImage(this.offscreenImage, 0, 0, null);
            }
            this.framesSkipped = false;
        } else if (this.paintingImmediately) {
            World world = this.workspace.world;
            synchronized (world) {
                this.renderer.paint((Graphics2D)graphics, (ViewSettings)this);
            }
            this.framesSkipped = false;
        } else if (this.beClean()) {
            graphics.drawImage(this.offscreenImage, 0, 0, null);
            this.framesSkipped = false;
        } else {
            this.framesSkipped = true;
        }
    }

    public void paintingImmediately(boolean bl) {
        this.paintingImmediately = bl;
    }

    public void paintImmediately(boolean bl) {
        if (this.viewIsVisible() && (this.framesSkipped || bl)) {
            this.paintingImmediately(true);
            this.paintImmediately();
            this.paintingImmediately(false);
        }
    }

    public boolean viewIsVisible() {
        return !this.iconified && this.isShowing();
    }

    public void paintImmediately() {
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage exportView() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setFont(this.getFont());
        World world = this.workspace.world;
        synchronized (world) {
            this.renderer.paint(graphics2D, (ViewSettings)this);
        }
        return bufferedImage;
    }

    void freeze() {
        if (!this.frozen) {
            this.frozen = true;
            if (this.workspace.world.displayOn()) {
                this.beClean();
            }
        }
    }

    void thaw() {
        if (this.frozen) {
            this.frozen = false;
            this.repaint();
        }
    }

    public void shapeChanged(Shape shape2) {
        this.dirty = true;
        new Events.DirtyEvent().raise(this);
        this.renderer.resetCache(this.patchSize());
        this.repaint();
    }

    public void handle(Events.LoadBeginEvent loadBeginEvent) {
        this.setVisible(false);
        this.patchSize = 13.0;
        this.zoom = 0.0;
        this.renderer = this.workspace.newRenderer();
    }

    public void handle(Events.LoadEndEvent loadEndEvent) {
        this.renderer.changeTopology(this.workspace.world.wrappingAllowedInX(), this.workspace.world.wrappingAllowedInY());
        this.setVisible(true);
    }

    public void handle(Events.CompiledEvent compiledEvent) {
        if (compiledEvent.sourceOwner instanceof ProceduresInterface) {
            this.renderer.resetCache(this.patchSize());
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.dirty = true;
            this.beClean();
        }
    }

    void setTrueFontSize(int n) {
        this.fontSize = n;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.offscreenImage = null;
        this.discardOffscreenImage();
    }

    public void applyNewFontSize(int n, int n2) {
        Font font = this.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), n + n2);
        this.setTrueFontSize(n);
        this.setFont(font2);
        this.dirty();
        this.repaint();
    }

    public Component getExportWindowFrame() {
        return this.workspace.viewWidget;
    }

    public double patchSize() {
        return this.patchSize + this.zoom;
    }

    public void visualPatchSize(double d) {
        double d2 = this.zoom;
        this.zoom = d - this.patchSize;
        if (this.zoom != d2) {
            this.renderer.resetCache(this.patchSize());
        }
    }

    public double viewWidth() {
        return this.viewWidth;
    }

    public double viewHeight() {
        return this.viewHeight;
    }

    public void setSize(int n, int n2, double d) {
        this.patchSize = d;
        this.viewWidth = n;
        this.viewHeight = n2;
        this.renderer.resetCache(this.patchSize());
    }

    public Perspective perspective() {
        return this.workspace.world.observer().perspective();
    }

    public boolean drawSpotlight() {
        return true;
    }

    public double viewOffsetX() {
        return this.workspace.world.observer().followOffsetX();
    }

    public double viewOffsetY() {
        return this.workspace.world.observer().followOffsetY();
    }

    public boolean renderPerspective() {
        return this.renderPerspective;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point populateContextMenu(JPopupMenu jPopupMenu, Point point, Component component) {
        Object object;
        if (!AbstractWorkspace.isApplet()) {
            object = new JMenuItem("Copy View");
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new ImageSelection(View.this.exportView()), null);
                }
            });
            jPopupMenu.add((JMenuItem)object);
            JMenuItem jMenuItem = new JMenuItem("Export View...");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    View.this.workspace.doExportView(View.this);
                }
            });
            jPopupMenu.add(jMenuItem);
        }
        if (!this.workspace.world.observer().atHome2D()) {
            jPopupMenu.add(new JPopupMenu.Separator());
            object = new JMenuItem("<html>" + Colors.colorize("reset-perspective", SyntaxColors.COMMAND_COLOR));
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    View.this.workspace.world.observer().resetPerspective();
                    View.this.workspace.viewManager.incrementalUpdateFromEventThread();
                }
            });
            jPopupMenu.add((JMenuItem)object);
        }
        point = new Point(point);
        this.mouser.translatePointToXCorYCor(point);
        object = this.workspace.world;
        synchronized (object) {
            Agent agent;
            AgentSet.Iterator iterator2;
            boolean bl;
            double d = this.mouser.translatePointToUnboundedX(point.x);
            double d2 = this.mouser.translatePointToUnboundedY(point.y);
            Patch patch = null;
            if (!AbstractWorkspace.isApplet()) {
                try {
                    patch = this.workspace.world.getPatchAt(d, d2);
                    jPopupMenu.add(new JPopupMenu.Separator());
                    jPopupMenu.add(new AgentMenuItem(patch, AgentMenuType.INSPECT, "inspect", false));
                }
                catch (AgentException agentException) {
                    Exceptions.ignore(agentException);
                }
                bl = false;
                iterator2 = this.workspace.world.links().iterator();
                while (iterator2.hasNext()) {
                    agent = (Link)iterator2.next();
                    if (((Link)agent).hidden() || !(this.workspace.world.protractor().distance(agent, d, d2, true) < ((Link)agent).lineThickness() + 0.5)) continue;
                    if (!bl) {
                        jPopupMenu.add(new JPopupMenu.Separator());
                        bl = true;
                    }
                    jPopupMenu.add(new AgentMenuItem(agent, AgentMenuType.INSPECT, "inspect", false));
                }
            }
            bl = false;
            iterator2 = this.workspace.world.turtles().iterator();
            while (iterator2.hasNext()) {
                double d3;
                double d4;
                VectorShape vectorShape;
                agent = (Turtle)iterator2.next();
                if (((Turtle)agent).hidden()) continue;
                double d5 = ((Turtle)agent).size() * 0.5;
                if (d5 * this.workspace.world.patchSize() < 3.0) {
                    d5 += 3.0 / this.workspace.world.patchSize();
                }
                if ((vectorShape = (VectorShape)this.workspace.world.turtleShapeList().shape(((Turtle)agent).shape())).isRotatable() && !((Turtle)agent).hidden()) {
                    d4 = this.workspace.world.protractor().distance(agent, d, d2, true);
                    if (!(d4 <= d5)) continue;
                    if (!bl) {
                        jPopupMenu.add(new JPopupMenu.Separator());
                        bl = true;
                    }
                    this.addTurtleToContextMenu(jPopupMenu, (Turtle)agent);
                    continue;
                }
                d4 = ((Turtle)agent).xcor();
                double d6 = ((Turtle)agent).ycor();
                double d7 = d;
                double d8 = d2;
                if (this.workspace.world.wrappingAllowedInX()) {
                    d3 = d4 > d7 ? d7 + (double)this.workspace.world.worldWidth() : d7 - (double)this.workspace.world.worldWidth();
                    double d9 = d7 = StrictMath.abs(d7 - d4) < StrictMath.abs(d3 - d4) ? d7 : d3;
                }
                if (this.workspace.world.wrappingAllowedInY()) {
                    d3 = d6 > d8 ? d8 + (double)this.workspace.world.worldHeight() : d8 - (double)this.workspace.world.worldHeight();
                    double d10 = d8 = StrictMath.abs(d8 - d6) < StrictMath.abs(d3 - d6) ? d8 : d3;
                }
                if (!(d7 >= d4 - d5) || !(d7 <= d4 + d5) || !(d8 >= d6 - d5) || !(d8 <= d6 + d5)) continue;
                if (!bl) {
                    jPopupMenu.add(new JPopupMenu.Separator());
                    bl = true;
                }
                this.addTurtleToContextMenu(jPopupMenu, (Turtle)agent);
            }
            int n = 0;
            int n2 = 0;
            if (patch != null) {
                n = (int)StrictMath.round(this.renderer.graphicsX(patch.pxcor + 1, this.patchSize(), this.viewOffsetX()));
                n2 = (int)StrictMath.round(this.renderer.graphicsY(patch.pycor - 1, this.patchSize(), this.viewOffsetY()));
                point.x += StrictMath.min(n - point.x, 15);
                point.y += StrictMath.min(n2 - point.y, 15);
            }
        }
        return point;
    }

    private void addTurtleToContextMenu(JPopupMenu jPopupMenu, Turtle turtle2) {
        AgentMenu agentMenu = new AgentMenu(turtle2);
        if (!AbstractWorkspace.isApplet()) {
            agentMenu.add(new AgentMenuItem(turtle2, AgentMenuType.INSPECT, "inspect", true));
            agentMenu.add(new JPopupMenu.Separator());
        }
        agentMenu.add(new AgentMenuItem(turtle2, AgentMenuType.WATCH, "watch", true));
        agentMenu.add(new AgentMenuItem(turtle2, AgentMenuType.FOLLOW, "follow", true));
        jPopupMenu.add(agentMenu);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        AgentMenuItem agentMenuItem = (AgentMenuItem)actionEvent.getSource();
        switch (agentMenuItem.type) {
            case INSPECT: {
                double d = StrictMath.min(this.workspace.world().worldWidth() / 2, this.workspace.world().worldHeight() / 2);
                double d2 = StrictMath.min(3.0, d / 2.0);
                this.workspace.inspectAgent(agentMenuItem.agent.getAgentClass(), agentMenuItem.agent, d2);
                return;
            }
            case FOLLOW: {
                this.workspace.world.observer().setPerspective(PerspectiveJ.FOLLOW(), agentMenuItem.agent);
                int n = (int)((Turtle)agentMenuItem.agent).size() * 5;
                this.workspace.world.observer().followDistance(StrictMath.max(1, StrictMath.min(n, 100)));
                break;
            }
            case WATCH: {
                this.workspace.world.observer().home();
                this.workspace.world.observer().setPerspective(PerspectiveJ.WATCH(), agentMenuItem.agent);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.workspace.viewManager.incrementalUpdateFromEventThread();
    }

    private strictfp class AgentMenu
    extends JMenu {
        Agent agent;

        AgentMenu(Agent agent) {
            super(agent.toString());
            this.agent = agent;
        }

        public void menuSelectionChanged(boolean bl) {
            super.menuSelectionChanged(bl);
            View.this.renderer.outlineAgent(bl ? this.agent : null);
            View.this.workspace.viewManager.incrementalUpdateFromEventThread();
        }
    }

    private strictfp class AgentMenuItem
    extends JMenuItem {
        Agent agent;
        AgentMenuType type;
        boolean submenu;

        AgentMenuItem(Agent agent, AgentMenuType agentMenuType, String string, boolean bl) {
            super("<html>" + Colors.colorize(string, SyntaxColors.COMMAND_COLOR) + " " + Colors.colorize(agent.classDisplayName(), SyntaxColors.REPORTER_COLOR) + Colors.colorize(agent.toString().substring(agent.classDisplayName().length()), SyntaxColors.CONSTANT_COLOR));
            this.submenu = false;
            this.agent = agent;
            this.type = agentMenuType;
            this.addActionListener(View.this);
            this.submenu = bl;
        }

        public void menuSelectionChanged(boolean bl) {
            super.menuSelectionChanged(bl);
            if (!this.submenu) {
                View.this.renderer.outlineAgent(bl ? this.agent : null);
                View.this.workspace.viewManager.incrementalUpdateFromEventThread();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    strictfp static enum AgentMenuType {
        INSPECT,
        FOLLOW,
        WATCH;

    }
}

