/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;
import org.nlogo.api.I18N;
import org.nlogo.awt.Fonts;
import org.nlogo.awt.RowLayout;
import org.nlogo.swing.OptionDialog;
import org.nlogo.swing.Utils;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.SpeedSliderPanel;
import org.nlogo.window.ViewWidget;

public strictfp class ViewControlStrip
extends JPanel {
    private final GUIWorkspace workspace;
    private final ViewWidget viewWidget;
    private final SizeControl sizeControlXY;
    private final SizeControl sizeControlX;
    private final SizeControl sizeControlY;
    private static final Point TOOL_TIP_OFFSET = new Point(0, -18);

    ViewControlStrip(GUIWorkspace gUIWorkspace, ViewWidget viewWidget) {
        JComponent jComponent;
        this.workspace = gUIWorkspace;
        this.viewWidget = viewWidget;
        this.setBackground(InterfaceColors.GRAPHICS_BACKGROUND);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(0);
        this.setLayout(borderLayout);
        if (gUIWorkspace.kioskLevel == GUIWorkspace.KioskLevel.NONE) {
            jComponent = new JPanel();
            jComponent.setLayout(new RowLayout(1, 1.0f, 0.5f));
            this.sizeControlXY = new SizeControl("/images/arrowsdiag.gif", 1, 1);
            this.sizeControlXY.setToolTipText("Change width and height of world");
            jComponent.add(this.sizeControlXY);
            this.sizeControlX = new SizeControl("/images/arrowsx.gif", 1, 0);
            this.sizeControlX.setToolTipText("Change width of world");
            jComponent.add(this.sizeControlX);
            this.sizeControlY = new SizeControl("/images/arrowsy.gif", 0, 1);
            this.sizeControlY.setToolTipText("Change height of world");
            jComponent.add(this.sizeControlY);
            this.add((Component)jComponent, "West");
            jComponent.setOpaque(false);
            this.add((Component)viewWidget.tickCounter, "Center");
        } else {
            this.sizeControlXY = null;
            this.sizeControlX = null;
            this.sizeControlY = null;
            this.add((Component)viewWidget.tickCounter, "West");
            jComponent = new SpeedSliderPanel(gUIWorkspace, false);
            jComponent.setOpaque(false);
            this.add((Component)jComponent, "Center");
        }
        if (gUIWorkspace.kioskLevel == GUIWorkspace.KioskLevel.NONE) {
            jComponent = new ThreedButton();
            this.add((Component)jComponent, "East");
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(super.getMinimumSize().width, 20);
    }

    public Dimension getPreferredSize() {
        if (this.viewWidget.isZoomed()) {
            return super.getPreferredSize();
        }
        return new Dimension(super.getPreferredSize().width, 20);
    }

    public void doLayout() {
        if (this.workspace.kioskLevel == GUIWorkspace.KioskLevel.NONE) {
            this.sizeControlXY.setVisible(true);
            this.sizeControlX.setVisible(true);
            this.sizeControlY.setVisible(true);
        }
        super.doLayout();
    }

    void reset() {
        this.enableSizeControls(this.workspace.world.maxPxcor() == -this.workspace.world.minPxcor() || this.workspace.world.minPxcor() == 0 || this.workspace.world.maxPxcor() == 0, this.workspace.world.maxPycor() == -this.workspace.world.minPycor() || this.workspace.world.minPycor() == 0 || this.workspace.world.maxPycor() == 0);
        this.doLayout();
    }

    void enableSizeControls(boolean bl, boolean bl2) {
        if (this.workspace.kioskLevel == GUIWorkspace.KioskLevel.NONE) {
            this.sizeControlX.setEnabled(bl);
            this.sizeControlY.setEnabled(bl2);
            this.sizeControlXY.setEnabled(bl && bl2);
        }
    }

    private boolean newSizeOK(int n, int n2) {
        return n >= 1 && n2 >= 1 && this.workspace.world.patchSize() * (double)n >= (double)this.getMinimumSize().width;
    }

    private boolean checkWithUser() {
        return !this.workspace.jobManager.anyPrimaryJobs() || OptionDialog.show(this, I18N.guiJ().get("common.messages.warning"), "Changing the size will halt and clear the world.", new String[]{"Change Size", I18N.guiJ().get("common.buttons.cancel")}) == 0;
    }

    private strictfp class SizeControl
    extends JButton
    implements ActionListener {
        private final int sexChange;
        private final int seyChange;
        private Point mousePressLoc;

        SizeControl(String string, int n, int n2) {
            this.sexChange = n;
            this.seyChange = n2;
            this.setOpaque(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.setIcon(new ImageIcon(SizeControl.class.getResource(string)));
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    SizeControl.this.mousePressLoc = mouseEvent.getPoint();
                }
            });
            this.addActionListener(this);
        }

        public Point getToolTipLocation(MouseEvent mouseEvent) {
            return TOOL_TIP_OFFSET;
        }

        public void updateUI() {
            this.setUI(new BasicButtonUI());
        }

        private boolean increase() {
            if (this.sexChange == 1 && this.seyChange == 0) {
                return this.mousePressLoc.x >= this.getWidth() / 2;
            }
            if (this.sexChange == 0 && this.seyChange == 1) {
                return this.mousePressLoc.y >= this.getHeight() / 2;
            }
            return this.mousePressLoc.x + this.mousePressLoc.y >= (this.getHeight() + this.getWidth()) / 2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!ViewControlStrip.this.checkWithUser()) {
                return;
            }
            int n = ((ViewControlStrip)ViewControlStrip.this).workspace.world.maxPxcor();
            int n2 = ((ViewControlStrip)ViewControlStrip.this).workspace.world.minPxcor();
            int n3 = ((ViewControlStrip)ViewControlStrip.this).workspace.world.maxPycor();
            int n4 = ((ViewControlStrip)ViewControlStrip.this).workspace.world.minPycor();
            int n5 = this.sexChange * (this.increase() ? 1 : -1);
            int n6 = this.seyChange * (this.increase() ? 1 : -1);
            int n7 = n2;
            int n8 = n;
            int n9 = n4;
            int n10 = n3;
            if (n == -n2) {
                n7 = n2 - n5;
                n8 = n + n5;
            } else if (n == 0) {
                n7 = n2 - n5;
            } else if (n2 == 0) {
                n8 = n + n5;
            }
            if (n3 == -n4) {
                n9 = n4 - n6;
                n10 = n3 + n6;
            } else if (n3 == 0) {
                n9 = n4 - n6;
            } else if (n4 == 0) {
                n10 = n3 + n6;
            }
            if (ViewControlStrip.this.newSizeOK(n8 - n7, n10 - n9) && (n7 != n2 || n8 != n || n9 != n4 || n10 != n3)) {
                ViewWidget viewWidget = (ViewWidget)((ViewControlStrip)ViewControlStrip.this).workspace.view.getParent();
                viewWidget.settings().setDimensions(n7, n8, n9, n10);
                viewWidget.settings().resizeWithProgress(false);
            }
        }
    }

    private strictfp class ThreedButton
    extends JButton {
        public ThreedButton() {
            super(" 3D ");
            this.setFont(new Font(Fonts.platformFont(), 0, 10));
            this.setBackground(InterfaceColors.GRAPHICS_BACKGROUND);
            this.setBorder(Utils.createWidgetBorder());
            this.setFocusable(false);
            this.setToolTipText("Switch to 3D view");
            this.addActionListener(((ViewControlStrip)ViewControlStrip.this).workspace.switchTo3DViewAction);
        }

        public Point getToolTipLocation(MouseEvent mouseEvent) {
            return TOOL_TIP_OFFSET;
        }

        public void updateUI() {
            this.setUI(new BasicButtonUI());
        }
    }
}

