/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.util.LinkedList;
import org.nlogo.api.ViewInterface;
import org.nlogo.awt.EventQueue;
import org.nlogo.window.LocalViewInterface;

public strictfp class ViewManager {
    private final LinkedList<ViewInterface> views = new LinkedList();
    private final Runnable updateRunnable = new Runnable(){

        public void run() {
            ViewManager.this.incrementalUpdateFromEventThread();
        }
    };

    public LocalViewInterface getPrimary() {
        return (LocalViewInterface)this.views.get(0);
    }

    public void setPrimary(LocalViewInterface localViewInterface) {
        this.views.remove(localViewInterface);
        this.views.addFirst(localViewInterface);
    }

    public void add(ViewInterface viewInterface) {
        this.views.addLast(viewInterface);
    }

    public void remove(ViewInterface viewInterface) {
        this.views.remove(viewInterface);
    }

    void paintImmediately(boolean bl) {
        for (ViewInterface viewInterface : this.views) {
            viewInterface.paintImmediately(bl);
        }
    }

    void framesSkipped() {
        for (ViewInterface viewInterface : this.views) {
            viewInterface.framesSkipped();
        }
    }

    void incrementalUpdateFromEventThread() {
        for (ViewInterface viewInterface : this.views) {
            if (viewInterface.isDead() || !viewInterface.viewIsVisible()) continue;
            viewInterface.incrementalUpdateFromEventThread();
        }
    }

    void incrementalUpdateFromJobThread() {
        try {
            EventQueue.invokeAndWait(this.updateRunnable);
        }
        catch (InterruptedException interruptedException) {
            this.getPrimary().repaint();
        }
    }

    void applyNewFontSize(int n) {
        for (ViewInterface viewInterface : this.views) {
            viewInterface.applyNewFontSize(n, 0);
        }
    }

    public boolean mouseDown() {
        for (ViewInterface viewInterface : this.views) {
            if (!viewInterface.mouseDown()) continue;
            return true;
        }
        return false;
    }

    public boolean mouseInside() {
        for (ViewInterface viewInterface : this.views) {
            if (!viewInterface.mouseInside()) continue;
            return true;
        }
        return false;
    }

    public double mouseXCor() {
        for (ViewInterface viewInterface : this.views) {
            if (!viewInterface.mouseInside()) continue;
            return viewInterface.mouseXCor();
        }
        return this.getPrimary().mouseXCor();
    }

    public double mouseYCor() {
        for (ViewInterface viewInterface : this.views) {
            if (!viewInterface.mouseInside()) continue;
            return viewInterface.mouseYCor();
        }
        return this.getPrimary().mouseYCor();
    }

    public void resetMouseCors() {
        for (ViewInterface viewInterface : this.views) {
            viewInterface.resetMouseCors();
        }
    }
}

