/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import org.nlogo.api.Approximate;
import org.nlogo.api.Dump;
import org.nlogo.api.Version;
import org.nlogo.awt.Fonts;
import org.nlogo.window.DisplaySwitch;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.MouseMode;
import org.nlogo.window.View;
import org.nlogo.window.ViewControlStrip;
import org.nlogo.window.ViewWidgetInterface;
import org.nlogo.window.Widget;
import org.nlogo.window.WorldViewSettings;
import org.nlogo.window.WorldViewSettings2D;
import org.nlogo.window.WorldViewSettings3D;

public strictfp class ViewWidget
extends Widget
implements Events.LoadBeginEvent.Handler,
Events.LoadEndEvent.Handler,
Events.PeriodicUpdateEvent.Handler,
ViewWidgetInterface {
    private final GUIWorkspace workspace;
    public final View view;
    public final ViewControlStrip controlStrip;
    public final JLabel tickCounter = new TickCounterLabel();
    public final DisplaySwitch displaySwitch;
    private final WorldViewSettings settings;
    private String tickCounterLabel;

    public String classDisplayName() {
        return "World & View";
    }

    public final int getExtraHeight() {
        return this.getInsets().top + this.getInsets().bottom + 1;
    }

    public int getAdditionalHeight() {
        return this.getExtraHeight() + this.controlStrip.getHeight();
    }

    ViewWidget(GUIWorkspace gUIWorkspace) {
        this.workspace = gUIWorkspace;
        this.displaySwitch = new DisplaySwitch(gUIWorkspace);
        Fonts.adjustDefaultFont(this.tickCounter);
        this.view = new View(gUIWorkspace);
        this.controlStrip = new ViewControlStrip(gUIWorkspace, this);
        this.setBackground(InterfaceColors.GRAPHICS_BACKGROUND);
        this.setBorder(BorderFactory.createCompoundBorder(this.widgetBorder(), BorderFactory.createMatteBorder(1, 3, 4, 2, InterfaceColors.GRAPHICS_BACKGROUND)));
        this.setLayout(null);
        this.add(this.view);
        this.add(this.controlStrip);
        this.settings = Version.is3D() ? new WorldViewSettings3D(gUIWorkspace, this) : new WorldViewSettings2D(gUIWorkspace, this);
    }

    public WorldViewSettings settings() {
        return this.settings;
    }

    public void doLayout() {
        int n = this.getWidth() - this.getInsets().left - this.getInsets().right;
        double d = this.computePatchSize(n, this.workspace.world.worldWidth());
        int n2 = (int)StrictMath.round(d * (double)this.workspace.world.worldHeight());
        int n3 = this.getHeight() - n2 - this.getInsets().top - this.getInsets().bottom;
        this.view.visualPatchSize(d);
        this.view.setBounds(this.getInsets().left, this.getInsets().top + 1 + n3, n, n2);
        this.controlStrip.setBounds(this.getInsets().left, this.getInsets().top, n, n3);
    }

    public Object getEditable() {
        return this.settings;
    }

    public double computePatchSize(int n, int n2) {
        double d = (double)n / (double)n2;
        for (int i = 0; i < 15; ++i) {
            double d2 = Approximate.approximate(d, i);
            if ((int)((double)n2 * d2) != n) continue;
            return d2;
        }
        return d;
    }

    public Dimension getPreferredSize(Font font) {
        return new Dimension(0, 0);
    }

    public boolean needsPreferredWidthFudgeFactor() {
        return false;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.view.getMinimumSize();
        Dimension dimension2 = this.controlStrip.getMinimumSize();
        if (dimension.width > dimension2.width) {
            return new Dimension(dimension.width + this.getInsets().left + this.getInsets().right, dimension.height + this.getExtraHeight() + dimension2.height);
        }
        int n = this.workspace.world.worldWidth();
        int n2 = this.workspace.world.worldHeight();
        double d = this.computePatchSize(dimension2.width, n);
        return new Dimension(dimension2.width + this.getInsets().left + this.getInsets().right, dimension2.height + this.getExtraHeight() + (int)(d * (double)n2));
    }

    public int insetWidth() {
        return this.getInsets().left + this.getInsets().right;
    }

    public int calculateWidth(int n, double d) {
        return (int)((double)n * d) + this.getInsets().right + this.getInsets().left;
    }

    public int calculateHeight(int n, double d) {
        Dimension dimension = this.controlStrip.getMinimumSize();
        return dimension.height + this.getExtraHeight() + (int)(d * (double)n);
    }

    public int getMinimumWidth() {
        return this.controlStrip.getMinimumSize().width + this.insetWidth();
    }

    void resetSize() {
        this.view.setSize(this.workspace.world.worldWidth(), this.workspace.world.worldHeight(), this.workspace.world.patchSize());
        Dimension dimension = this.view.getPreferredSize();
        this.setSize(dimension.width + this.getInsets().left + this.getInsets().right, dimension.height + this.getExtraHeight() + this.controlStrip.getPreferredSize().height);
        this.doLayout();
        this.resetZoomInfo();
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        new Events.ResizeViewEvent(this.workspace.world.worldWidth(), this.workspace.world.worldHeight()).raise(this);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getBounds();
        if (n3 != rectangle.width || n4 != rectangle.height || n != rectangle.x || n2 != rectangle.y) {
            super.setBounds(n, n2, n3, n4);
            this.resetSizeInfo();
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public String getBoundsString() {
        Rectangle rectangle = this.findWidgetContainer() == null ? this.getBounds() : this.findWidgetContainer().getUnzoomedBounds(this);
        int n = StrictMath.max(245, rectangle.width);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(rectangle.x + "\n");
        stringBuilder.append(rectangle.y + "\n");
        stringBuilder.append(rectangle.x + n + "\n");
        stringBuilder.append(rectangle.y + rectangle.height + "\n");
        return stringBuilder.toString();
    }

    public Rectangle constrainDrag(Rectangle rectangle, Rectangle rectangle2, MouseMode mouseMode) {
        int n = this.controlStrip.getMinimumSize().height;
        double d = this.computePatchSize(rectangle.width - this.getInsets().left + this.getInsets().right, this.workspace.world.worldWidth());
        double d2 = this.computePatchSize(rectangle.height - n - this.getExtraHeight(), this.workspace.world.worldHeight());
        double d3 = rectangle.height == rectangle2.height ? d : (rectangle.width == rectangle2.width ? d2 : StrictMath.max(d, d2));
        this.workspace.world.patchSize(d3);
        this.view.setSize(this.workspace.world.worldWidth(), this.workspace.world.worldHeight(), d3);
        this.view.renderer.trailDrawer().rescaleDrawing();
        int n2 = (int)(d3 * (double)this.workspace.world.worldWidth()) + this.getInsets().left + this.getInsets().right;
        int n3 = (int)(d3 * (double)this.workspace.world.worldHeight()) + this.getExtraHeight() + n;
        int n4 = rectangle.width - n2;
        int n5 = rectangle.height - n3;
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        switch (mouseMode) {
            case NE: {
                n7 += n5;
                break;
            }
            case NW: {
                n6 += n4;
                n7 += n5;
                break;
            }
            case SE: {
                break;
            }
            case SW: {
                n6 += n4;
                break;
            }
            case S: {
                break;
            }
            case W: {
                n6 += n4;
                break;
            }
            case E: {
                break;
            }
            case N: {
                n7 += n5;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (mouseMode) {
            case S: 
            case N: {
                int n8 = rectangle2.x + rectangle2.width / 2;
                n6 = n8 - n2 / 2;
                break;
            }
            case W: 
            case E: {
                int n9 = rectangle2.y + rectangle2.height / 2;
                n7 = n9 - n3 / 2;
                break;
            }
        }
        return new Rectangle(n6, n7, n2, n3);
    }

    void applyNewFontSize(int n) {
        Font font = this.view.getFont();
        int n2 = font.getSize() - this.view.fontSize();
        this.view.applyNewFontSize(n, n2);
    }

    public boolean zoomSubcomponents() {
        return true;
    }

    public Widget asWidget() {
        return this;
    }

    public void handle(Events.LoadBeginEvent loadBeginEvent) {
        this.tickCounter.setText("");
        this.tickCounterLabel = "ticks";
        this.tickCounter.setVisible(true);
    }

    public void handle(Events.LoadEndEvent loadEndEvent) {
        this.controlStrip.reset();
    }

    public void handle(Events.PeriodicUpdateEvent periodicUpdateEvent) {
        double d = this.workspace.world.tickCounter.ticks();
        String string = d == -1.0 ? "" : Dump.number(StrictMath.floor(d));
        this.tickCounter.setText("     " + this.tickCounterLabel + ": " + string);
    }

    public void showTickCounter(boolean bl) {
        this.tickCounter.setVisible(bl);
    }

    public boolean showTickCounter() {
        return this.tickCounter.isVisible();
    }

    public void tickCounterLabel(String string) {
        this.tickCounterLabel = string;
        this.handle((Events.PeriodicUpdateEvent)null);
    }

    public String tickCounterLabel() {
        return this.tickCounterLabel;
    }

    public boolean hasContextMenu() {
        return true;
    }

    public Point populateContextMenu(JPopupMenu jPopupMenu, Point point, Component component) {
        return this.view.populateContextMenu(jPopupMenu, point, component);
    }

    void displaySwitchOn(boolean bl) {
        this.displaySwitch.actionPerformed(null);
    }

    public String save() {
        return this.settings.save();
    }

    public Object load(String[] stringArray, Widget.LoadHelper loadHelper2) {
        return this.settings.load(stringArray, loadHelper2.version());
    }

    public boolean copyable() {
        return false;
    }

    private strictfp class TickCounterLabel
    extends JLabel {
        private TickCounterLabel() {
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            dimension.width = StrictMath.max(dimension.width, fontMetrics.stringWidth(ViewWidget.this.tickCounterLabel + ": 00000000"));
            return dimension;
        }
    }
}

