/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import org.nlogo.agent.World3D;
import org.nlogo.api.I18N;
import org.nlogo.api.WorldDimensions;
import org.nlogo.api.WorldDimensions3D;
import org.nlogo.awt.Hierarchy;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.OriginConfiguration;
import org.nlogo.window.Properties;
import org.nlogo.window.ViewWidget;
import org.nlogo.window.WorldViewSettings;

public strictfp class WorldViewSettings3D
extends WorldViewSettings {
    protected final World3D world;
    protected int newMinZ;
    protected int newMaxZ;

    WorldViewSettings3D(GUIWorkspace gUIWorkspace, ViewWidget viewWidget) {
        super(gUIWorkspace, viewWidget);
        this.world = (World3D)gUIWorkspace.world;
    }

    public void addDimensionProperties() {
        this.dimensionProperties.addAll(Properties.dims3D());
    }

    public void addWrappingProperties() {
        this.wrappingProperties.addAll(Properties.wrap3D());
    }

    public void addCornerChoices() {
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.corner.bottomSouthwest"), new boolean[]{false, true, false, true, false, true}, new boolean[]{true, false, true, false, true, false}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.corner.bottomNorthwest"), new boolean[]{false, true, true, false, false, true}, new boolean[]{true, false, false, true, true, false}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.corner.bottomNortheast"), new boolean[]{true, false, true, false, false, true}, new boolean[]{false, true, false, true, true, false}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.corner.bottomSoutheast"), new boolean[]{true, false, false, true, false, true}, new boolean[]{false, true, true, false, true, false}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.corner.topSouthwest"), new boolean[]{false, true, false, true, true, false}, new boolean[]{true, false, true, false, false, true}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.corner.topNorthwest"), new boolean[]{false, true, true, false, true, false}, new boolean[]{true, false, false, true, false, true}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.corner.topNortheast"), new boolean[]{true, false, true, false, true, false}, new boolean[]{false, true, false, true, false, true}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.corner.topSoutheast"), new boolean[]{true, false, false, true, true, false}, new boolean[]{false, true, true, false, false, true}));
    }

    public void addEdgeChoices() {
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.edge.south"), new boolean[]{true, true, false, true, true, true}, new boolean[]{false, false, true, false, false, false}));
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.edge.north"), new boolean[]{true, true, true, false, true, true}, new boolean[]{false, false, false, true, false, false}));
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.edge.east"), new boolean[]{true, false, true, true, true, true}, new boolean[]{false, true, false, false, false, false}));
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.edge.west"), new boolean[]{false, true, true, true, true, true}, new boolean[]{true, false, false, false, false, false}));
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.edge.bottom"), new boolean[]{true, true, true, true, false, true}, new boolean[]{false, false, false, false, true, false}));
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.edge.top"), new boolean[]{true, true, true, true, true, false}, new boolean[]{false, false, false, false, false, true}));
    }

    public void addOriginConfigurations() {
        this.originConfigurations.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.center"), new boolean[]{false, true, false, true, false, true}, new boolean[]{false, false, false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.corner"), new boolean[]{true, true, true, true, true, true}, new boolean[]{false, false, false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.edge"), new boolean[]{true, true, true, true, true, true}, new boolean[]{false, false, false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.custom"), new boolean[]{true, true, true, true, true, true}, new boolean[]{false, false, false, false, false, false}));
    }

    public boolean editFinished() {
        this.gWidget.editFinished();
        if (this.wrappingChanged) {
            this.workspace.changeTopology(this.newWrapX, this.newWrapY);
            this.wrappingChanged = false;
        }
        if (this.edgesChanged || this.patchSizeChanged) {
            this.resizeWithProgress(true);
            this.edgesChanged = false;
            this.patchSizeChanged = false;
        }
        if (this.fontSizeChanged) {
            this.gWidget.applyNewFontSize(this.newFontSize);
            this.fontSizeChanged = false;
        }
        this.gWidget.view.dirty();
        this.gWidget.view.repaint();
        this.workspace.glView.editFinished();
        return true;
    }

    public void resizeWithProgress(boolean bl) {
        boolean bl2 = this.world.displayOn();
        if (bl2) {
            this.world.displayOn(false);
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (WorldViewSettings3D.this.edgesChanged) {
                    new Events.RemoveAllJobsEvent().raise(WorldViewSettings3D.this.gWidget);
                    WorldViewSettings3D.this.world.clearTurtles();
                    WorldViewSettings3D.this.world.clearLinks();
                    WorldViewSettings3D.this.world.createPatches(WorldViewSettings3D.this.newMinX, WorldViewSettings3D.this.newMaxX, WorldViewSettings3D.this.newMinY, WorldViewSettings3D.this.newMaxY, WorldViewSettings3D.this.newMinZ, WorldViewSettings3D.this.newMaxZ);
                    WorldViewSettings3D.this.workspace.patchesCreatedNotify();
                    WorldViewSettings3D.this.gWidget.resetSize();
                }
                if (WorldViewSettings3D.this.patchSizeChanged) {
                    WorldViewSettings3D.this.world.patchSize(WorldViewSettings3D.this.newPatchSize);
                    WorldViewSettings3D.this.gWidget.resetSize();
                }
                if (WorldViewSettings3D.this.edgesChanged) {
                    WorldViewSettings3D.this.workspace.clearDrawing();
                } else {
                    WorldViewSettings3D.this.gWidget.view.renderer.trailDrawer().rescaleDrawing();
                }
            }
        };
        if (bl) {
            ModalProgressTask.apply(Hierarchy.getFrame(this.gWidget), "Resizing...", runnable);
        } else {
            runnable.run();
        }
        this.gWidget.displaySwitchOn(true);
        if (bl2) {
            this.world.displayOn(true);
            this.gWidget.view.dirty();
            this.gWidget.view.repaint();
        }
    }

    public void setDimensions(WorldDimensions worldDimensions) {
        if (worldDimensions instanceof WorldDimensions3D) {
            WorldDimensions3D worldDimensions3D = (WorldDimensions3D)worldDimensions;
            this.setDimensions(worldDimensions3D.minPxcor(), worldDimensions3D.maxPxcor(), worldDimensions3D.minPycor(), worldDimensions3D.maxPycor(), worldDimensions3D.minPzcor(), worldDimensions3D.maxPzcor());
        } else {
            this.setDimensions(worldDimensions.minPxcor(), worldDimensions.maxPxcor(), worldDimensions.minPycor(), worldDimensions.maxPycor(), 0, 0);
        }
    }

    public void setDimensions(int n, int n2, int n3, int n4, int n5, int n6) {
        this.newMinX = n;
        this.newMaxX = n2;
        this.newMinY = n3;
        this.newMaxY = n4;
        this.newMinZ = n5;
        this.newMaxZ = n6;
        if (n != this.world.minPxcor() || n2 != this.world.maxPxcor() || n3 != this.world.minPycor() || n4 != this.world.maxPycor() || n5 != this.world.minPzcor() || n6 != this.world.maxPzcor()) {
            this.prepareForWorldResize();
            this.world.createPatches(n, n2, n3, n4, n5, n6);
            this.finishWorldResize();
        }
    }

    public String save() {
        return "GRAPHICS-WINDOW\n" + this.gWidget.getBoundsString() + (-this.world.minPxcor() == this.world.maxPxcor() ? this.world.maxPxcor() : -1) + "\n" + (-this.world.minPycor() == this.world.maxPycor() ? this.world.maxPycor() : -1) + "\n" + this.world.patchSize() + "\n" + "1\n" + this.gWidget.view.fontSize() + "\n" + "1\n1\n1\n0\n" + (this.world.wrappingAllowedInX() ? "1" : "0") + "\n" + (this.world.wrappingAllowedInY() ? "1" : "0") + "\n" + "1\n" + this.world.minPxcor() + "\n" + this.world.maxPxcor() + "\n" + this.world.minPycor() + "\n" + this.world.maxPycor() + "\n" + this.world.minPzcor() + "\n" + this.world.maxPzcor() + "\n" + (this.world.wrappingAllowedInZ() ? "1" : "0") + "\n" + this.workspace.updateMode().save() + "\n" + (this.showTickCounter() ? "1" : "0") + "\n" + (this.tickCounterLabel().trim().equals("") ? "NIL" : this.tickCounterLabel()) + "\n" + this.frameRate() + "\n";
    }
}

