/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.nlogo.agent.Agent;
import org.nlogo.agent.Importer;
import org.nlogo.agent.OutputObject;
import org.nlogo.agent.World;
import org.nlogo.api.CompilerException;
import org.nlogo.api.Dump;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.File;
import org.nlogo.api.FileModeJ;
import org.nlogo.api.HubNetInterface;
import org.nlogo.api.HubNetWorkspaceInterface;
import org.nlogo.api.ImportErrorHandler;
import org.nlogo.api.LocalFile;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoThunkFactory;
import org.nlogo.api.ModelType;
import org.nlogo.api.ModelTypeJ;
import org.nlogo.api.RemoteFile;
import org.nlogo.api.Token;
import org.nlogo.api.Version;
import org.nlogo.api.WorldPropertiesInterface;
import org.nlogo.nvm.Activation;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.CompilerInterface;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.FileManager;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.JobManagerInterface;
import org.nlogo.nvm.MutableLong;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Tracer;
import org.nlogo.nvm.Workspace;
import org.nlogo.util.Exceptions;
import org.nlogo.util.Femto;
import org.nlogo.util.MersenneTwisterFast;
import org.nlogo.workspace.BufferedReaderImporter;
import org.nlogo.workspace.DefaultFileManager;
import org.nlogo.workspace.Evaluator;
import org.nlogo.workspace.ExtensionManager;
import org.nlogo.workspace.WorldLoader;
import org.nlogo.workspace.WorldLoader3D;
import org.nlogo.workspace.WorldLoaderInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class AbstractWorkspace
implements HubNetWorkspaceInterface,
LogoThunkFactory,
Workspace {
    public final World world;
    protected final DefaultFileManager fileManager;
    private Tracer tracer = null;
    public final JobManagerInterface jobManager;
    private final HubNetManagerFactory hubNetManagerFactory;
    protected HubNetInterface hubNetManager;
    protected final Evaluator evaluator;
    protected final ExtensionManager extensionManager;
    private final WeakHashMap<Job, WeakHashMap<Agent, WeakHashMap<Command, MutableLong>>> lastRunTimes = new WeakHashMap();
    private final WeakHashMap<Activation, Boolean> completedActivations = new WeakHashMap();
    protected String modelFileName;
    private String modelDir;
    private ModelType modelType;
    private static boolean isApp = false;
    private static boolean isApplet = true;
    protected boolean hubNetRunning = false;
    private Map<String, Procedure> procedures = new HashMap<String, Procedure>();
    public WeakHashMap<String, Procedure> codeBits = new WeakHashMap();
    private Workspace.UpdateMode updateMode = Workspace.UpdateMode.CONTINUOUS;
    private int _behaviorSpaceRunNumber = 0;

    @Override
    public World world() {
        return this.world;
    }

    @Override
    public FileManager fileManager() {
        return this.fileManager;
    }

    @Override
    public Tracer profilingTracer() {
        return this.tracer;
    }

    @Override
    public boolean profilingEnabled() {
        return this.tracer != null;
    }

    @Override
    public WeakHashMap<Job, WeakHashMap<Agent, WeakHashMap<Command, MutableLong>>> lastRunTimes() {
        return this.lastRunTimes;
    }

    @Override
    public WeakHashMap<Activation, Boolean> completedActivations() {
        return this.completedActivations;
    }

    protected AbstractWorkspace(World world, HubNetManagerFactory hubNetManagerFactory) {
        this.world = world;
        this.hubNetManagerFactory = hubNetManagerFactory;
        this.modelType = ModelTypeJ.NEW();
        this.evaluator = new Evaluator(this);
        world.compiler_$eq(this);
        this.jobManager = Femto.get(JobManagerInterface.class, "org.nlogo.job.JobManager", new Object[]{this, world, world});
        this.fileManager = new DefaultFileManager(this);
        this.extensionManager = new ExtensionManager(this);
    }

    @Override
    public org.nlogo.api.ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Override
    public boolean isExtensionName(String string) {
        return this.extensionManager.isExtensionName(string);
    }

    @Override
    public void importExtensionData(String string, List<String[]> list, ImportErrorHandler importErrorHandler) throws ExtensionException {
        this.extensionManager.importExtensionData(string, list, importErrorHandler);
    }

    public abstract boolean compilerTestingMode();

    @Override
    public void dispose() throws InterruptedException {
        this.jobManager.die();
        this.getExtensionManager().reset();
        if (this.hubNetManager != null) {
            this.hubNetManager.disconnect();
        }
    }

    public boolean warningMessage(String string) {
        System.err.println();
        System.err.println("WARNING: " + string);
        System.err.println();
        return true;
    }

    public static boolean isApp() {
        return isApp;
    }

    public static boolean isApplet() {
        return isApplet;
    }

    public static void isApplet(boolean bl) {
        isApplet = bl;
    }

    @Override
    public boolean getIsApplet() {
        return isApplet;
    }

    @Override
    public HubNetInterface getHubNetManager() {
        if (this.hubNetManager == null && this.hubNetManagerFactory != null) {
            this.hubNetManager = this.hubNetManagerFactory.newInstance(this);
        }
        return this.hubNetManager;
    }

    public HubNetInterface hubnetManager() {
        return this.hubNetManager;
    }

    public boolean hubNetRunning() {
        return this.hubNetRunning;
    }

    @Override
    public void hubNetRunning(boolean bl) {
        this.hubNetRunning = bl;
    }

    @Override
    public WorldPropertiesInterface getPropertiesInterface() {
        return null;
    }

    @Override
    public void setModelPath(String string) {
        if (string == null) {
            this.modelFileName = null;
            this.modelDir = null;
        } else {
            java.io.File file = new java.io.File(string).getAbsoluteFile();
            this.modelFileName = file.getName();
            this.modelDir = file.getParent();
            if (this.modelDir.equals("")) {
                this.modelDir = null;
            }
            if (this.modelDir != null) {
                this.fileManager.setPrefix(this.modelDir);
            }
        }
    }

    @Override
    public String attachModelDir(String string) throws MalformedURLException {
        if (AbstractWorkspace.isApplet() || new java.io.File(string).isAbsolute()) {
            return string;
        }
        String string2 = this.getModelPath();
        if (string2 == null) {
            string2 = System.getProperty("user.home") + java.io.File.separatorChar + "dummy.txt";
        }
        URL uRL = new URL(AbstractWorkspace.toURL(new java.io.File(string2)), string);
        return new java.io.File(uRL.getFile()).getAbsolutePath();
    }

    public static URL toURL(java.io.File file) throws MalformedURLException {
        return file.toURL();
    }

    @Override
    public String convertToNormal() throws IOException {
        java.io.File file = new java.io.File(".git");
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException("no .git directory found");
        }
        this.modelType = ModelTypeJ.NORMAL();
        return this.getModelPath();
    }

    protected void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    @Override
    public String getModelPath() {
        if (this.modelDir == null || this.modelFileName == null) {
            return null;
        }
        return this.modelDir + java.io.File.separatorChar + this.modelFileName;
    }

    @Override
    public String getModelFileName() {
        return this.modelFileName;
    }

    @Override
    public String getModelDir() {
        return this.modelDir;
    }

    @Override
    public String modelNameForDisplay() {
        return AbstractWorkspace.makeModelNameForDisplay(this.modelFileName);
    }

    static String makeModelNameForDisplay(String string) {
        if (string == null) {
            return "Untitled";
        }
        int n = string.lastIndexOf(".nlogo");
        if (n > 0 && n == string.length() - 6) {
            string = string.substring(0, string.length() - 6);
        }
        if ((n = string.lastIndexOf(".nlogo3d")) > 0 && n == string.length() - 8) {
            string = string.substring(0, string.length() - 8);
        }
        return string;
    }

    @Override
    public Map<String, Procedure> getProcedures() {
        return this.procedures;
    }

    @Override
    public void setProcedures(Map<String, Procedure> map2) {
        this.procedures = map2;
    }

    public void init() {
        for (Procedure procedure : this.procedures.values()) {
            procedure.init(this);
        }
    }

    @Override
    public void joinForeverButtons(Agent agent) {
        this.jobManager.joinForeverButtons(agent);
    }

    @Override
    public void addJobFromJobThread(Job job) {
        this.jobManager.addJobFromJobThread(job);
    }

    @Override
    public Procedure compileForRun(String string, Context context, boolean bl) throws CompilerException {
        String string2 = string + "@" + context.activation.procedure.args.size() + "@" + context.agentBit;
        Procedure procedure = this.codeBits.get(string2);
        if (procedure == null) {
            procedure = this.evaluator.compileForRun(string, context, bl);
            this.codeBits.put(string2, procedure);
        }
        return procedure;
    }

    public Workspace.UpdateMode updateMode() {
        return this.updateMode;
    }

    public void updateMode(Workspace.UpdateMode updateMode) {
        this.updateMode = updateMode;
    }

    public void halt() {
        this.jobManager.haltPrimary();
        this.world.displayOn(true);
    }

    @Override
    public abstract void requestDisplayUpdate(boolean var1);

    @Override
    public void outputObject(Object object, Object object2, boolean bl, boolean bl2, Workspace.OutputDestination outputDestination) throws LogoException {
        OutputObject outputObject = new OutputObject(object2 instanceof Agent ? Dump.logoObject(object2) : "", (bl2 && !(object2 instanceof Agent) ? " " : "") + Dump.logoObject(object, bl2, false), bl, false);
        if (outputDestination == Workspace.OutputDestination.FILE) {
            this.fileManager.writeOutputObject(outputObject);
        } else {
            this.sendOutput(outputObject, outputDestination == Workspace.OutputDestination.OUTPUT_AREA);
        }
    }

    protected abstract void sendOutput(OutputObject var1, boolean var2) throws LogoException;

    @Override
    public void setOutputAreaContents(String string) {
        try {
            this.clearOutput();
            if (string.length() > 0) {
                this.sendOutput(new OutputObject("", string, false, false), true);
            }
        }
        catch (LogoException logoException) {
            Exceptions.handle(logoException);
        }
    }

    @Override
    public abstract void clearDrawing();

    protected void exportInterfaceGlobals(PrintWriter printWriter) {
        printWriter.println(Dump.csv().header("MODEL SETTINGS"));
        List<String> list = this.world.program().interfaceGlobals();
        printWriter.println(Dump.csv().variableNameRow(list));
        Object[] objectArray = new Object[list.size()];
        int n = 0;
        Iterator<String> iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            objectArray[n] = this.world.getObserverVariableByName(iterator2.next());
            ++n;
        }
        printWriter.println(Dump.csv().dataRow(objectArray));
        printWriter.println();
    }

    @Override
    public abstract void clearAll();

    protected abstract Importer.ErrorHandler importerErrorHandler();

    @Override
    public void importWorld(String string) throws IOException {
        this.clearAll();
        this.doImport(new BufferedReaderImporter(string){

            public void doImport(BufferedReader bufferedReader) throws IOException {
                AbstractWorkspace.this.world.importWorld(AbstractWorkspace.this.importerErrorHandler(), AbstractWorkspace.this, AbstractWorkspace.this.stringReader(), bufferedReader);
            }
        });
    }

    @Override
    public void importWorld(Reader reader) throws IOException {
        this.clearAll();
        this.world.importWorld(this.importerErrorHandler(), this, this.stringReader(), new BufferedReader(reader));
    }

    private final Importer.StringReader stringReader() {
        return new Importer.StringReader(){

            public Object readFromString(String string) throws Importer.StringReaderException {
                try {
                    return AbstractWorkspace.this.compiler().readFromString(string, AbstractWorkspace.this.world, AbstractWorkspace.this.extensionManager, AbstractWorkspace.this.world.program().is3D());
                }
                catch (CompilerException compilerException) {
                    throw new Importer.StringReaderException(compilerException.getMessage());
                }
            }
        };
    }

    @Override
    public void importDrawing(String string) throws IOException {
        this.doImport(new FileImporter(string){

            public void doImport(File file) throws IOException {
                AbstractWorkspace.this.importDrawing(file);
            }
        });
    }

    protected abstract void importDrawing(File var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(BufferedReaderImporter bufferedReaderImporter) throws IOException {
        LocalFile localFile = new LocalFile(bufferedReaderImporter.filename());
        try {
            ((File)localFile).open(FileModeJ.READ());
            bufferedReaderImporter.doImport(localFile.reader());
        }
        finally {
            try {
                ((File)localFile).close(false);
            }
            catch (IOException iOException) {
                Exceptions.ignore(iOException);
            }
        }
    }

    protected void doImport(FileImporter fileImporter) throws IOException {
        File file = AbstractWorkspace.isApplet() ? new RemoteFile(fileImporter.filename) : new LocalFile(fileImporter.filename);
        fileImporter.doImport(file);
    }

    public String guessExportName(String string) {
        String string2 = this.getModelFileName();
        if (string2 == null) {
            return string;
        }
        int n = string2.lastIndexOf(".nlogo");
        if (n > -1) {
            string2 = string2.substring(0, n);
        }
        return string2 + " " + string;
    }

    @Override
    public int behaviorSpaceRunNumber() {
        return this._behaviorSpaceRunNumber;
    }

    @Override
    public void behaviorSpaceRunNumber(int n) {
        this._behaviorSpaceRunNumber = n;
    }

    public String getSource(String string) throws IOException {
        File file;
        String string2;
        if (string.equals("aggregate")) {
            return this.aggregateManager().innerSource();
        }
        if (AbstractWorkspace.isApplet()) {
            string2 = this.fileManager().attachPrefix(string);
            file = new RemoteFile(string2);
        } else {
            file = new LocalFile(string);
        }
        string2 = file.readFile();
        return string2.replaceAll("\r\n", "\n");
    }

    @Override
    public String autoConvert(String string, boolean bl, boolean bl2, String string2) {
        return this.compiler().autoConvert(string, bl, bl2, string2, this, true, this.world().program().is3D());
    }

    public void loadWorld(String[] stringArray, String string, WorldLoaderInterface worldLoaderInterface) {
        WorldLoader worldLoader = Version.is3D(string) ? new WorldLoader3D() : new WorldLoader();
        worldLoader.load(stringArray, string, worldLoaderInterface);
    }

    @Override
    public MersenneTwisterFast auxRNG() {
        return this.world.auxRNG;
    }

    @Override
    public MersenneTwisterFast mainRNG() {
        return this.world.mainRNG;
    }

    @Override
    public Object readNumberFromString(String string) throws CompilerException {
        return this.compiler().readNumberFromString(string, this.world, this.getExtensionManager(), this.world.program().is3D());
    }

    @Override
    public void checkReporterSyntax(String string) throws CompilerException {
        this.compiler().checkReporterSyntax(string, this.world.program(), this.getProcedures(), this.getExtensionManager(), false);
    }

    @Override
    public void checkCommandSyntax(String string) throws CompilerException {
        this.compiler().checkCommandSyntax(string, this.world.program(), this.getProcedures(), this.getExtensionManager(), false);
    }

    @Override
    public boolean isConstant(String string) {
        try {
            this.compiler().readFromString(string, this.world.program().is3D());
            return true;
        }
        catch (CompilerException compilerException) {
            return false;
        }
    }

    @Override
    public boolean isValidIdentifier(String string) {
        return this.compiler().isValidIdentifier(string, this.world.program().is3D());
    }

    @Override
    public boolean isReporter(String string) {
        return this.compiler().isReporter(string, this.world.program(), this.getProcedures(), this.getExtensionManager());
    }

    @Override
    public Token[] tokenizeForColorization(String string) {
        return this.compiler().tokenizeForColorization(string, this.getExtensionManager(), this.world.program().is3D());
    }

    @Override
    public Token getTokenAtPosition(String string, int n) {
        return this.compiler().getTokenAtPosition(string, n);
    }

    @Override
    public Map<String, List<Object>> findProcedurePositions(String string) {
        return this.compiler().findProcedurePositions(string, this.world.program().is3D());
    }

    @Override
    public abstract CompilerInterface compiler();

    @Override
    public LogoException lastLogoException() {
        return null;
    }

    @Override
    public void clearLastLogoException() {
    }

    protected strictfp abstract class FileImporter {
        public String filename;

        FileImporter(String string) {
            this.filename = string;
        }

        public abstract void doImport(File var1) throws IOException;
    }

    public static interface HubNetManagerFactory {
        public HubNetInterface newInstance(AbstractWorkspace var1);
    }
}

