/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.Array$;
import scala.Function1;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.generic.Growable$class;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Builder$class;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassManifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappedArrayBuilder<A>
implements Builder<A, WrappedArray<A>>,
ScalaObject {
    private final ClassManifest<A> manifest;
    private WrappedArray<A> elems;
    private int capacity;
    private int size;

    @Override
    public void sizeHint(TraversableLike<?, ?> traversableLike, int n) {
        Builder$class.sizeHint(this, traversableLike, n);
    }

    @Override
    public void sizeHintBounded(int n, TraversableLike<?, ?> traversableLike) {
        Builder$class.sizeHintBounded(this, n, traversableLike);
    }

    @Override
    public <NewTo> Builder<A, NewTo> mapResult(Function1<WrappedArray<A>, NewTo> function1) {
        return Builder$class.mapResult(this, function1);
    }

    @Override
    public int sizeHint$default$2() {
        return Builder$class.sizeHint$default$2(this);
    }

    @Override
    public Growable<A> $plus$eq(A a, A a2, Seq<A> seq) {
        return Growable$class.$plus$eq(this, a, a2, seq);
    }

    @Override
    public Growable<A> $plus$plus$eq(TraversableOnce<A> traversableOnce) {
        return Growable$class.$plus$plus$eq(this, traversableOnce);
    }

    private WrappedArray<A> elems() {
        return this.elems;
    }

    private void elems_$eq(WrappedArray<A> wrappedArray) {
        this.elems = wrappedArray;
    }

    private int capacity() {
        return this.capacity;
    }

    private void capacity_$eq(int n) {
        this.capacity = n;
    }

    private int size() {
        return this.size;
    }

    private void size_$eq(int n) {
        this.size = n;
    }

    private WrappedArray<A> mkArray(int n) {
        WrappedArray<A> wrappedArray = this.manifest.newWrappedArray(n);
        if (this.size() > 0) {
            Array$.MODULE$.copy(this.elems().array(), 0, wrappedArray.array(), 0, this.size());
        }
        return wrappedArray;
    }

    private void resize(int n) {
        this.elems_$eq(this.mkArray(n));
        this.capacity_$eq(n);
    }

    @Override
    public void sizeHint(int n) {
        if (this.capacity() < n) {
            this.resize(n);
        }
    }

    private void ensureSize(int n) {
        if (this.capacity() < n) {
            int n2;
            int n3 = n2 = this.capacity() == 0 ? 16 : this.capacity() * 2;
            while (n2 < n) {
                n2 *= 2;
            }
            this.resize(n2);
        }
    }

    @Override
    public WrappedArrayBuilder<A> $plus$eq(A a) {
        this.ensureSize(this.size() + 1);
        this.elems().update(this.size(), a);
        this.size_$eq(this.size() + 1);
        return this;
    }

    @Override
    public WrappedArray<A> result() {
        return this.capacity() != 0 && this.capacity() == this.size() ? this.elems() : this.mkArray(this.size());
    }

    public WrappedArrayBuilder(ClassManifest<A> classManifest) {
        this.manifest = classManifest;
        Growable$class.$init$(this);
        Builder$class.$init$(this);
        this.capacity = 0;
        this.size = 0;
    }
}

