/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaComboBoxCellRenderer;
import ch.randelshofer.quaqua.QuaquaComboBoxUI;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboPopup;

public class QuaquaComboPopup
extends BasicComboPopup {
    private QuaquaComboBoxUI qqui;
    private Handler handler;
    private Component lastFocused;
    private JRootPane invokerRootPane;
    private boolean focusTraversalKeysEnabled;
    private static final Border comboCellBorder = new EmptyBorder(0, 7, 0, 7);

    public QuaquaComboPopup(JComboBox cBox, QuaquaComboBoxUI qqui) {
        super(cBox);
        this.qqui = qqui;
        this.updateCellRenderer(qqui.isTableCellEditor());
    }

    public void show() {
        this.setListSelection(this.comboBox.getSelectedIndex());
        Point location = this.getPopupLocation();
        this.show(this.comboBox, location.x, location.y);
        this.setBorder(UIManager.getBorder("ComboBox.popupBorder"));
        this.list.repaint();
    }

    public void hide() {
        super.hide();
    }

    public void setVisible(boolean newValue) {
        super.setVisible(newValue);
        if (newValue) {
            if (!this.comboBox.isEditable() && this.comboBox != KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) {
                this.lastFocused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                this.invokerRootPane = SwingUtilities.getRootPane(this.comboBox);
                if (this.invokerRootPane != null) {
                    this.invokerRootPane.requestFocus(true);
                    this.invokerRootPane.addKeyListener(this.getHandler());
                    this.focusTraversalKeysEnabled = this.invokerRootPane.getFocusTraversalKeysEnabled();
                    this.invokerRootPane.setFocusTraversalKeysEnabled(false);
                }
            }
        } else {
            if (this.lastFocused != null) {
                Window cfw;
                if (!this.lastFocused.requestFocusInWindow() && (cfw = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) != null && "###focusableSwingPopup###".equals(cfw.getName())) {
                    this.lastFocused.requestFocus();
                }
                this.lastFocused = null;
            }
            if (this.invokerRootPane != null) {
                this.invokerRootPane.removeKeyListener(this.getHandler());
                this.invokerRootPane.setFocusTraversalKeysEnabled(this.focusTraversalKeysEnabled);
                this.invokerRootPane = null;
            }
        }
    }

    private void updateCellRenderer(boolean isTableCellEditor) {
        this.list.setCellRenderer(new QuaquaComboBoxCellRenderer(this.comboBox.getRenderer(), isTableCellEditor, this.comboBox.isEditable()));
    }

    private int getMaximumRowCount() {
        return this.isEditable() || this.isTableCellEditor() ? this.comboBox.getMaximumRowCount() : 100;
    }

    private Point getPopupLocation() {
        Dimension popupSize = this.comboBox.getSize();
        Insets insets = this.getInsets();
        popupSize.setSize(popupSize.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.getMaximumRowCount()));
        Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
        Dimension scrollSize = popupBounds.getSize();
        Point popupLocation = popupBounds.getLocation();
        this.scroller.setMaximumSize(scrollSize);
        this.scroller.setPreferredSize(scrollSize);
        this.scroller.setMinimumSize(scrollSize);
        this.list.revalidate();
        return popupLocation;
    }

    private void setListSelection(int selectedIndex) {
        if (selectedIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
            this.list.ensureIndexIsVisible(selectedIndex);
        }
    }

    protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
        Rectangle screenBounds;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int listWidth = this.getList().getPreferredSize().width;
        Insets margin = this.qqui.getMargin();
        boolean isTableCellEditor = this.isTableCellEditor();
        boolean hasScrollBars = this.hasScrollBars();
        boolean isEditable = this.isEditable();
        if (isTableCellEditor) {
            pw = hasScrollBars ? Math.max(pw, listWidth + 16) : Math.max(pw, listWidth);
        } else if (hasScrollBars) {
            px += margin.left;
            pw = Math.max(pw - margin.left - margin.right, listWidth + 16);
        } else if (isEditable) {
            px += margin.left;
            pw = Math.max(pw - this.qqui.getArrowWidth() - margin.left, listWidth);
        } else {
            px += margin.left;
            pw = Math.max(pw - this.qqui.getArrowWidth() - margin.left, listWidth);
        }
        Insets cellBorderInsets = comboCellBorder.getBorderInsets(this);
        pw += cellBorderInsets.left + cellBorderInsets.right;
        GraphicsConfiguration gc = this.comboBox.getGraphicsConfiguration();
        Point p = new Point();
        SwingUtilities.convertPointFromScreen(p, this.comboBox);
        if (gc != null) {
            Insets screenInsets = toolkit.getScreenInsets(gc);
            screenBounds = new Rectangle(gc.getBounds());
            screenBounds.width -= screenInsets.left + screenInsets.right;
            screenBounds.height -= screenInsets.top + screenInsets.bottom;
            screenBounds.x += screenInsets.left;
            screenBounds.y += screenInsets.top;
        } else {
            screenBounds = new Rectangle(p, toolkit.getScreenSize());
        }
        if (this.isDropDown()) {
            if (!isTableCellEditor) {
                py = isEditable ? (py -= margin.bottom + 2) : (py -= margin.bottom);
            }
        } else {
            int yOffset = isTableCellEditor ? 7 : 3 - margin.top;
            int selectedIndex = this.comboBox.getSelectedIndex();
            py = selectedIndex <= 0 ? -yOffset : -yOffset - this.list.getCellBounds((int)0, (int)(selectedIndex - 1)).height;
        }
        Rectangle rect = new Rectangle(px - p.x, py - p.y, pw, ph);
        if (screenBounds.height < ph) {
            rect.width += 16;
        }
        rect = screenBounds.intersection(rect);
        rect.x += p.x;
        rect.y += p.y;
        return rect;
    }

    private boolean isDropDown() {
        return this.comboBox.isEditable() || this.hasScrollBars();
    }

    private boolean hasScrollBars() {
        return this.comboBox.getModel().getSize() > this.getMaximumRowCount();
    }

    private boolean isEditable() {
        return this.comboBox.isEditable();
    }

    private boolean isTableCellEditor() {
        return this.qqui.isTableCellEditor();
    }

    protected void configurePopup() {
        super.configurePopup();
        this.setBorder(UIManager.getBorder("ComboBox.popupBorder"));
        this.setFocusable(true);
    }

    protected void configureList() {
        super.configureList();
        this.list.setBackground(UIManager.getColor("PopupMenu.background"));
        this.list.setFocusable(true);
        this.list.setRequestFocusEnabled(true);
        this.list.putClientProperty("Quaqua.List.style", "comboPopup");
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.getHandler();
    }

    protected KeyListener createKeyListener() {
        return this.getHandler();
    }

    protected ListSelectionListener createListSelectionListener() {
        return null;
    }

    protected ListDataListener createListDataListener() {
        return null;
    }

    protected MouseListener createListMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createListMouseMotionListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected ItemListener createItemListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    private class Handler
    implements ItemListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    Serializable,
    KeyListener {
        private Handler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getSource() == QuaquaComboPopup.this.list) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e) || !QuaquaComboPopup.this.comboBox.isEnabled()) {
                return;
            }
            if (QuaquaComboPopup.this.comboBox.isEditable()) {
                Component comp = QuaquaComboPopup.this.comboBox.getEditor().getEditorComponent();
                if (!(comp instanceof JComponent) || ((JComponent)comp).isRequestFocusEnabled()) {
                    comp.requestFocus();
                }
            } else if (QuaquaComboPopup.this.comboBox.isRequestFocusEnabled()) {
                QuaquaComboPopup.this.comboBox.requestFocus();
            }
            QuaquaComboPopup.this.togglePopup();
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getSource() == QuaquaComboPopup.this.list) {
                if (QuaquaComboPopup.this.list.getModel().getSize() > 0) {
                    if (QuaquaComboPopup.this.comboBox.getSelectedIndex() != QuaquaComboPopup.this.list.getSelectedIndex()) {
                        QuaquaComboPopup.this.comboBox.setSelectedIndex(QuaquaComboPopup.this.list.getSelectedIndex());
                    } else {
                        QuaquaComboPopup.this.comboBox.getEditor().setItem(QuaquaComboPopup.this.list.getSelectedValue());
                    }
                }
                QuaquaComboPopup.this.comboBox.setPopupVisible(false);
                if (QuaquaComboPopup.this.comboBox.isEditable() && QuaquaComboPopup.this.comboBox.getEditor() != null) {
                    QuaquaComboPopup.this.comboBox.configureEditor(QuaquaComboPopup.this.comboBox.getEditor(), QuaquaComboPopup.this.comboBox.getSelectedItem());
                }
                return;
            }
            Component source = (Component)e.getSource();
            Dimension size = source.getSize();
            Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
            if (!bounds.contains(e.getPoint())) {
                MouseEvent newEvent = QuaquaComboPopup.this.convertMouseEvent(e);
                Point location = newEvent.getPoint();
                Rectangle r = new Rectangle();
                QuaquaComboPopup.this.list.computeVisibleRect(r);
                if (r.contains(location)) {
                    if (QuaquaComboPopup.this.comboBox.getSelectedIndex() != QuaquaComboPopup.this.list.getSelectedIndex()) {
                        QuaquaComboPopup.this.comboBox.setSelectedIndex(QuaquaComboPopup.this.list.getSelectedIndex());
                    } else {
                        QuaquaComboPopup.this.comboBox.getEditor().setItem(QuaquaComboPopup.this.list.getSelectedValue());
                    }
                }
                QuaquaComboPopup.this.comboBox.setPopupVisible(false);
            }
            QuaquaComboPopup.this.hasEntered = false;
            QuaquaComboPopup.this.stopAutoScrolling();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent anEvent) {
            if (anEvent.getSource() == QuaquaComboPopup.this.list) {
                Point location = anEvent.getPoint();
                Rectangle r = new Rectangle();
                QuaquaComboPopup.this.list.computeVisibleRect(r);
                if (r.contains(location)) {
                    QuaquaComboPopup.this.updateListBoxSelectionForEvent(anEvent, false);
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (e.getSource() == QuaquaComboPopup.this.list) {
                return;
            }
            if (QuaquaComboPopup.this.isVisible()) {
                MouseEvent newEvent = QuaquaComboPopup.this.convertMouseEvent(e);
                Rectangle r = new Rectangle();
                QuaquaComboPopup.this.list.computeVisibleRect(r);
                if (newEvent.getPoint().y >= r.y && newEvent.getPoint().y <= r.y + r.height - 1) {
                    Point location;
                    QuaquaComboPopup.this.hasEntered = true;
                    if (QuaquaComboPopup.this.isAutoScrolling) {
                        QuaquaComboPopup.this.stopAutoScrolling();
                    }
                    if (r.contains(location = newEvent.getPoint())) {
                        QuaquaComboPopup.this.updateListBoxSelectionForEvent(newEvent, false);
                    }
                } else if (QuaquaComboPopup.this.hasEntered) {
                    int directionToScroll;
                    int n = directionToScroll = newEvent.getPoint().y < r.y ? 0 : 1;
                    if (QuaquaComboPopup.this.isAutoScrolling && QuaquaComboPopup.this.scrollDirection != directionToScroll) {
                        QuaquaComboPopup.this.stopAutoScrolling();
                        QuaquaComboPopup.this.startAutoScrolling(directionToScroll);
                    } else if (!QuaquaComboPopup.this.isAutoScrolling) {
                        QuaquaComboPopup.this.startAutoScrolling(directionToScroll);
                    }
                } else if (e.getPoint().y < 0) {
                    QuaquaComboPopup.this.hasEntered = true;
                    QuaquaComboPopup.this.startAutoScrolling(0);
                }
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            String propertyName = e.getPropertyName();
            if (propertyName == "model") {
                ComboBoxModel oldModel = (ComboBoxModel)e.getOldValue();
                ComboBoxModel newModel = (ComboBoxModel)e.getNewValue();
                QuaquaComboPopup.this.uninstallComboBoxModelListeners(oldModel);
                QuaquaComboPopup.this.installComboBoxModelListeners(newModel);
                QuaquaComboPopup.this.list.setModel(newModel);
                if (QuaquaComboPopup.this.isVisible()) {
                    QuaquaComboPopup.this.hide();
                }
            } else if (propertyName == "renderer") {
                QuaquaComboPopup.this.list.setCellRenderer(comboBox.getRenderer());
                if (QuaquaComboPopup.this.isVisible()) {
                    QuaquaComboPopup.this.hide();
                }
            } else if (propertyName == "componentOrientation") {
                ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                JList<Object> list = QuaquaComboPopup.this.getList();
                if (list != null && list.getComponentOrientation() != o) {
                    list.setComponentOrientation(o);
                }
                if (QuaquaComboPopup.this.scroller != null && QuaquaComboPopup.this.scroller.getComponentOrientation() != o) {
                    QuaquaComboPopup.this.scroller.setComponentOrientation(o);
                }
                if (o != QuaquaComboPopup.this.getComponentOrientation()) {
                    QuaquaComboPopup.this.setComponentOrientation(o);
                }
            } else if (propertyName == "lightWeightPopupEnabled") {
                QuaquaComboPopup.this.setLightWeightPopupEnabled(comboBox.isLightWeightPopupEnabled());
            } else if (propertyName.equals("renderer") || propertyName.equals("JComboBox.isTableCellEditor")) {
                QuaquaComboPopup.this.updateCellRenderer(e.getNewValue().equals(Boolean.TRUE));
            } else if (propertyName.equals("JComboBox.lightweightKeyboardNavigation")) {
                QuaquaComboPopup.this.updateCellRenderer(e.getNewValue() != null && e.getNewValue().equals("Lightweight"));
            } else if (propertyName.equals("editable")) {
                QuaquaComboPopup.this.updateCellRenderer(QuaquaComboPopup.this.isTableCellEditor());
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                JComboBox comboBox = (JComboBox)e.getSource();
                QuaquaComboPopup.this.setListSelection(comboBox.getSelectedIndex());
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            this.processKeyEvent(e, true);
            if (!(e.isConsumed() || QuaquaComboPopup.this.comboBox.isEditable() || QuaquaComboPopup.this.comboBox.isFocusOwner())) {
                QuaquaComboBoxUI ui = (QuaquaComboBoxUI)QuaquaComboPopup.this.comboBox.getUI();
                ui.getKeyListener().keyPressed(e);
            }
        }

        public void keyReleased(KeyEvent e) {
            this.processKeyEvent(e, false);
        }

        private boolean processKeyEvent(KeyEvent e, boolean pressed) {
            if (!(e.isConsumed() || QuaquaComboPopup.this.comboBox.isEditable() || QuaquaComboPopup.this.comboBox.isFocusOwner())) {
                int condition = 1;
                KeyStroke ks = e.getID() == 400 ? KeyStroke.getKeyStroke(e.getKeyChar()) : KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers(), !pressed);
                InputMap map = QuaquaComboPopup.this.comboBox.getInputMap(condition);
                ActionMap am = QuaquaComboPopup.this.comboBox.getActionMap();
                if (map != null && am != null && QuaquaComboPopup.this.isEnabled()) {
                    Action action;
                    Object binding = map.get(ks);
                    Action action2 = action = binding == null ? null : am.get(binding);
                    if (action != null) {
                        e.consume();
                        return SwingUtilities.notifyAction(action, ks, e, QuaquaComboPopup.this.comboBox, e.getModifiers());
                    }
                }
            }
            return false;
        }
    }
}

