/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisuallyLayoutable;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.InsetsUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSliderUI;

public class QuaquaSliderUI
extends BasicSliderUI
implements VisuallyLayoutable {
    private Handler handler;
    private transient boolean isDragging;

    public static ComponentUI createUI(JComponent b) {
        return new QuaquaSliderUI((JSlider)b);
    }

    public QuaquaSliderUI(JSlider b) {
        super(b);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        QuaquaUtilities.installProperty(c, "opaque", UIManager.get("Slider.opaque"));
    }

    public void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        this.focusInsets = this.getVisualMargin(slider);
        slider.setRequestFocusEnabled(UIManager.getBoolean("Slider.requestFocusEnabled"));
        slider.setFocusable(UIManager.getBoolean("CheckBox.focusable"));
    }

    protected void uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        this.handler = null;
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new QuaquaTrackListener();
    }

    protected ChangeListener createChangeListener(JSlider slider) {
        return this.getHandler();
    }

    protected ComponentListener createComponentListener(JSlider slider) {
        return this.getHandler();
    }

    protected FocusListener createFocusListener(JSlider slider) {
        return this.getHandler();
    }

    protected BasicSliderUI.ScrollListener createScrollListener(JSlider slider) {
        return new BasicSliderUI.ScrollListener(this);
    }

    protected PropertyChangeListener createPropertyChangeListener(JSlider slider) {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected Dimension getThumbSize() {
        Icon thumb = this.getThumbIcon();
        return new Dimension(thumb.getIconWidth(), thumb.getIconHeight());
    }

    protected boolean isSmall() {
        return QuaquaUtilities.isSmallSizeVariant(this.slider);
    }

    protected Icon getThumbIcon() {
        String suffix;
        String string = suffix = this.isSmall() ? ".small" : "";
        if (this.slider.getPaintTicks()) {
            if (this.slider.getOrientation() == 0) {
                if (QuaquaUtilities.isLeftToRight(this.slider)) {
                    return UIManager.getIcon("Slider.southThumb" + suffix);
                }
                return UIManager.getIcon("Slider.northThumb" + suffix);
            }
            if (QuaquaUtilities.isLeftToRight(this.slider)) {
                return UIManager.getIcon("Slider.eastThumb" + suffix);
            }
            return UIManager.getIcon("Slider.westThumb" + suffix);
        }
        return UIManager.getIcon("Slider.roundThumb" + suffix);
    }

    public void paint(Graphics gr, JComponent c) {
        Graphics2D g = (Graphics2D)gr;
        Object oldHints = QuaquaUtilities.beginGraphics(g);
        super.paint(g, c);
        QuaquaUtilities.endGraphics(g, oldHints);
        Debug.paint(g, c, this);
    }

    public void paintThumb(Graphics g) {
        Rectangle knobBounds = this.thumbRect;
        int x = knobBounds.x;
        int y = knobBounds.y;
        this.getThumbIcon().paintIcon(this.slider, g, x, y);
    }

    public void paintLabels(Graphics g) {
        g.setColor(this.slider.getForeground());
        super.paintLabels(g);
    }

    public void paintFocus(Graphics g) {
    }

    protected void calculateGeometry() {
        this.focusInsets = this.getVisualMargin(this.slider);
        super.calculateGeometry();
    }

    protected void calculateContentRect() {
        this.contentRect.x = this.focusRect.x + this.focusInsets.left;
        this.contentRect.y = this.focusRect.y + this.focusInsets.top;
        this.contentRect.width = this.focusRect.width - (this.focusInsets.left + this.focusInsets.right);
        this.contentRect.height = this.focusRect.height - (this.focusInsets.top + this.focusInsets.bottom);
    }

    protected void calculateThumbLocation() {
        int valuePosition;
        if (this.slider.getSnapToTicks()) {
            int sliderValue;
            int snappedValue = sliderValue = this.slider.getValue();
            int majorTickSpacing = this.slider.getMajorTickSpacing();
            int minorTickSpacing = this.slider.getMinorTickSpacing();
            int tickSpacing = 0;
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0) {
                if ((sliderValue - this.slider.getMinimum()) % tickSpacing != 0) {
                    float temp = (float)(sliderValue - this.slider.getMinimum()) / (float)tickSpacing;
                    int whichTick = Math.round(temp);
                    snappedValue = this.slider.getMinimum() + whichTick * tickSpacing;
                }
                if (snappedValue != sliderValue) {
                    this.slider.setValue(snappedValue);
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            valuePosition = this.xPositionForValue(this.slider.getValue());
            this.thumbRect.x = valuePosition - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y + (this.trackRect.height - this.thumbRect.height) / 2;
        } else {
            valuePosition = this.yPositionForValue(this.slider.getValue());
            this.thumbRect.x = this.trackRect.x + (this.trackRect.width - this.thumbRect.width) / 2;
            this.thumbRect.y = valuePosition - this.thumbRect.height / 2;
        }
    }

    protected void calculateLabelRect() {
        if (this.slider.getPaintLabels()) {
            if (this.slider.getOrientation() == 0) {
                this.labelRect.x = this.tickRect.x - this.trackBuffer;
                this.labelRect.width = this.tickRect.width + this.trackBuffer * 2;
                this.labelRect.height = this.getHeightOfTallestLabel();
                this.labelRect.y = QuaquaUtilities.isLeftToRight(this.slider) ? this.tickRect.y + this.tickRect.height : this.tickRect.y - this.labelRect.height;
            } else {
                this.labelRect.y = this.tickRect.y - this.trackBuffer;
                this.labelRect.height = this.tickRect.height + this.trackBuffer * 2;
                this.labelRect.width = this.getWidthOfWidestLabel();
                this.labelRect.x = QuaquaUtilities.isLeftToRight(this.slider) ? this.tickRect.x + this.tickRect.width : this.tickRect.x - this.labelRect.width;
            }
        } else if (this.slider.getOrientation() == 0) {
            this.labelRect.x = this.tickRect.x;
            this.labelRect.y = this.tickRect.y + this.tickRect.height;
            this.labelRect.width = this.tickRect.width;
            this.labelRect.height = 0;
        } else {
            this.labelRect.x = QuaquaUtilities.isLeftToRight(this.slider) ? this.tickRect.x + this.tickRect.width : this.tickRect.x;
            this.labelRect.y = this.tickRect.y;
            this.labelRect.width = 0;
            this.labelRect.height = this.tickRect.height;
        }
    }

    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            this.tickRect.y = QuaquaUtilities.isLeftToRight(this.slider) ? this.trackRect.y + this.trackRect.height : this.trackRect.y - this.tickRect.height;
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.y;
                this.tickRect.height = 0;
            }
        } else {
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
            this.tickRect.width = this.getTickLength();
            this.tickRect.x = QuaquaUtilities.isLeftToRight(this.slider) ? this.trackRect.x + this.trackRect.width : this.trackRect.x - this.tickRect.width - 1;
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.x;
                this.tickRect.width = 0;
            }
        }
    }

    protected void calculateTrackRect() {
        int centerSpacing = 0;
        if (this.slider.getOrientation() == 0) {
            centerSpacing = this.thumbRect.height;
            if (QuaquaUtilities.isLeftToRight(this.slider)) {
                if (this.slider.getPaintTicks()) {
                    centerSpacing += this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    centerSpacing += this.getHeightOfTallestLabel();
                }
            } else {
                if (this.slider.getPaintTicks()) {
                    centerSpacing -= this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    centerSpacing -= this.getHeightOfTallestLabel();
                }
            }
            this.trackRect.x = this.contentRect.x + this.trackBuffer;
            this.trackRect.y = this.contentRect.y + (this.contentRect.height - centerSpacing - 1) / 2 + 1;
            this.trackRect.width = this.contentRect.width - this.trackBuffer * 2;
            this.trackRect.height = this.thumbRect.height - 2;
        } else {
            centerSpacing = this.thumbRect.width;
            if (QuaquaUtilities.isLeftToRight(this.slider)) {
                if (this.slider.getPaintTicks()) {
                    centerSpacing += this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    centerSpacing += this.getWidthOfWidestLabel();
                }
            } else {
                if (this.slider.getPaintTicks()) {
                    centerSpacing -= this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    centerSpacing -= this.getWidthOfWidestLabel();
                }
            }
            this.trackRect.x = this.contentRect.x + (this.contentRect.width - centerSpacing - 1) / 2 + 1;
            this.trackRect.y = this.contentRect.y + this.trackBuffer;
            this.trackRect.width = this.thumbRect.width - 2;
            this.trackRect.height = this.contentRect.height - this.trackBuffer * 2;
        }
    }

    public void paintTrack(Graphics g) {
        Rectangle trackBounds = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int index = this.slider.isEnabled() ? 0 : 1;
            Border border = ((Border[])UIManager.get("Slider.horizontalTracks"))[index];
            Insets insets = border.getBorderInsets(this.slider);
            int offset = 0;
            if (this.slider.getPaintTicks()) {
                offset = this.isSmall() ? (QuaquaUtilities.isLeftToRight(this.slider) ? -1 : 1) : (QuaquaUtilities.isLeftToRight(this.slider) ? -3 : 3);
            }
            border.paintBorder(this.slider, g, trackBounds.x - this.thumbRect.width / 2 + 3, trackBounds.y + (trackBounds.height - insets.top - insets.bottom) / 2 + offset, trackBounds.width + this.thumbRect.width - 6, insets.top + insets.bottom);
        } else {
            int index = this.slider.isEnabled() ? 0 : 1;
            Border border = ((Border[])UIManager.get("Slider.verticalTracks"))[index];
            Insets insets = border.getBorderInsets(this.slider);
            int offset = 0;
            if (this.slider.getPaintTicks()) {
                offset = this.isSmall() ? (QuaquaUtilities.isLeftToRight(this.slider) ? -1 : 1) : (QuaquaUtilities.isLeftToRight(this.slider) ? -3 : 3);
            }
            int x = trackBounds.x + (trackBounds.width - insets.left - insets.right) / 2;
            border.paintBorder(this.slider, g, x + offset, trackBounds.y - this.thumbRect.height / 2 + 3, insets.left + insets.right, trackBounds.height + this.thumbRect.height - 6);
        }
    }

    public void paintTicks(Graphics g) {
        Rectangle tickBounds = this.tickRect;
        g.setColor(UIManager.getColor("Slider.tickColor"));
        if (this.slider.getOrientation() == 0) {
            g.translate(0, tickBounds.y);
            int value = this.slider.getMinimum();
            int xPos = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                int offset = 0;
                if (!QuaquaUtilities.isLeftToRight(this.slider)) {
                    offset = tickBounds.height - tickBounds.height / 2;
                    g.translate(0, offset);
                }
                while (value <= this.slider.getMaximum()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMinorTickForHorizSlider(g, tickBounds, xPos);
                    value += this.slider.getMinorTickSpacing();
                }
                if (!QuaquaUtilities.isLeftToRight(this.slider)) {
                    g.translate(0, -offset);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                value = this.slider.getMinimum();
                if (!QuaquaUtilities.isLeftToRight(this.slider)) {
                    g.translate(0, 1);
                }
                while (value <= this.slider.getMaximum()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMajorTickForHorizSlider(g, tickBounds, xPos);
                    value += this.slider.getMajorTickSpacing();
                }
                if (!QuaquaUtilities.isLeftToRight(this.slider)) {
                    g.translate(0, -1);
                }
            }
            g.translate(0, -tickBounds.y);
        } else {
            g.translate(tickBounds.x, 0);
            int value = this.slider.getMinimum();
            int yPos = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                int offset = 0;
                if (!QuaquaUtilities.isLeftToRight(this.slider)) {
                    offset = tickBounds.width - tickBounds.width / 2;
                    g.translate(offset, 0);
                }
                while (value <= this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMinorTickForVertSlider(g, tickBounds, yPos);
                    value += this.slider.getMinorTickSpacing();
                }
                if (!QuaquaUtilities.isLeftToRight(this.slider)) {
                    g.translate(-offset, 0);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                value = this.slider.getMinimum();
                if (!QuaquaUtilities.isLeftToRight(this.slider)) {
                    g.translate(2, 0);
                }
                while (value <= this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMajorTickForVertSlider(g, tickBounds, yPos);
                    value += this.slider.getMajorTickSpacing();
                }
                if (!QuaquaUtilities.isLeftToRight(this.slider)) {
                    g.translate(-2, 0);
                }
            }
            g.translate(-tickBounds.x, 0);
        }
    }

    InputMap getInputMap(int condition, JSlider slider) {
        if (condition == 0) {
            InputMap rtlKeyMap;
            InputMap keyMap = (InputMap)UIManager.get("Slider.focusInputMap");
            if (slider.getComponentOrientation().isLeftToRight() || (rtlKeyMap = (InputMap)UIManager.get("Slider.focusInputMap.RightToLeft")) == null) {
                return keyMap;
            }
            rtlKeyMap.setParent(keyMap);
            return rtlKeyMap;
        }
        return null;
    }

    public Insets getVisualMargin(JSlider tc) {
        Insets margin = (Insets)tc.getClientProperty("Quaqua.Component.visualMargin");
        if (margin == null) {
            margin = UIManager.getInsets("Component.visualMargin");
        }
        return margin == null ? new Insets(0, 0, 0, 0) : (Insets)margin.clone();
    }

    public Rectangle getVisualBounds(JComponent c, int type, int width, int height) {
        Border border;
        Rectangle bounds = new Rectangle(0, 0, width, height);
        if (type == 0) {
            return bounds;
        }
        JSlider b = (JSlider)c;
        if (type == 1 && ((border = b.getBorder()) == null || border instanceof UIResource)) {
            InsetsUtil.subtractInto(this.getVisualMargin(b), bounds);
        }
        return bounds;
    }

    public int getBaseline(JComponent c, int width, int height) {
        return -1;
    }

    public class QuaquaTrackListener
    extends BasicSliderUI.TrackListener {
        public QuaquaTrackListener() {
            super(QuaquaSliderUI.this);
        }

        public void mouseReleased(MouseEvent e) {
            if (!QuaquaSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.offset = 0;
            QuaquaSliderUI.this.scrollTimer.stop();
            if (QuaquaSliderUI.this.slider.getSnapToTicks()) {
                QuaquaSliderUI.this.isDragging = false;
                QuaquaSliderUI.this.slider.setValueIsAdjusting(false);
            } else {
                QuaquaSliderUI.this.slider.setValueIsAdjusting(false);
                QuaquaSliderUI.this.isDragging = false;
            }
            QuaquaSliderUI.this.slider.repaint();
        }

        public void mousePressed(MouseEvent e) {
            if (!QuaquaSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (QuaquaSliderUI.this.slider.isRequestFocusEnabled()) {
                QuaquaSliderUI.this.slider.requestFocus();
            }
            if (QuaquaSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                switch (QuaquaSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((QuaquaSliderUI)QuaquaSliderUI.this).thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((QuaquaSliderUI)QuaquaSliderUI.this).thumbRect.x;
                    }
                }
                QuaquaSliderUI.this.isDragging = true;
                return;
            }
            QuaquaSliderUI.this.isDragging = false;
            QuaquaSliderUI.this.slider.setValueIsAdjusting(true);
            Dimension sbSize = QuaquaSliderUI.this.slider.getSize();
            int direction = 1;
            switch (QuaquaSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int scrollbarCenter;
                    if (QuaquaSliderUI.this.thumbRect.isEmpty()) {
                        scrollbarCenter = sbSize.height / 2;
                        if (!QuaquaSliderUI.this.drawInverted()) {
                            direction = this.currentMouseY < scrollbarCenter ? 1 : -1;
                            break;
                        }
                        direction = this.currentMouseY < scrollbarCenter ? -1 : 1;
                        break;
                    }
                    int thumbY = ((QuaquaSliderUI)QuaquaSliderUI.this).thumbRect.y;
                    if (!QuaquaSliderUI.this.drawInverted()) {
                        direction = this.currentMouseY < thumbY ? 1 : -1;
                        break;
                    }
                    direction = this.currentMouseY < thumbY ? -1 : 1;
                    break;
                }
                case 0: {
                    int scrollbarCenter;
                    if (QuaquaSliderUI.this.thumbRect.isEmpty()) {
                        scrollbarCenter = sbSize.width / 2;
                        if (!QuaquaSliderUI.this.drawInverted()) {
                            direction = this.currentMouseX < scrollbarCenter ? -1 : 1;
                            break;
                        }
                        direction = this.currentMouseX < scrollbarCenter ? 1 : -1;
                        break;
                    }
                    int thumbX = ((QuaquaSliderUI)QuaquaSliderUI.this).thumbRect.x;
                    direction = !QuaquaSliderUI.this.drawInverted() ? (this.currentMouseX < thumbX ? -1 : 1) : (this.currentMouseX < thumbX ? 1 : -1);
                }
            }
            QuaquaSliderUI.this.scrollDueToClickInTrack(direction);
            Rectangle r = QuaquaSliderUI.this.thumbRect;
            if (!r.contains(this.currentMouseX, this.currentMouseY) && this.shouldScroll(direction)) {
                QuaquaSliderUI.this.scrollTimer.stop();
                QuaquaSliderUI.this.scrollListener.setDirection(direction);
                QuaquaSliderUI.this.scrollTimer.start();
            }
        }

        public boolean shouldScroll(int direction) {
            Rectangle r = QuaquaSliderUI.this.thumbRect;
            if (QuaquaSliderUI.this.slider.getOrientation() == 1 ? ((QuaquaSliderUI.this.drawInverted() ? direction < 0 : direction > 0) ? r.y + r.height <= this.currentMouseY : r.y >= this.currentMouseY) : ((QuaquaSliderUI.this.drawInverted() ? direction < 0 : direction > 0) ? r.x + r.width >= this.currentMouseX : r.x <= this.currentMouseX)) {
                return false;
            }
            if (direction > 0 && QuaquaSliderUI.this.slider.getValue() + QuaquaSliderUI.this.slider.getExtent() >= QuaquaSliderUI.this.slider.getMaximum()) {
                return false;
            }
            return direction >= 0 || QuaquaSliderUI.this.slider.getValue() > QuaquaSliderUI.this.slider.getMinimum();
        }

        public void mouseDragged(MouseEvent e) {
            int thumbMiddle = 0;
            if (!QuaquaSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (!QuaquaSliderUI.this.isDragging) {
                return;
            }
            QuaquaSliderUI.this.slider.setValueIsAdjusting(true);
            switch (QuaquaSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = ((QuaquaSliderUI)QuaquaSliderUI.this).thumbRect.height / 2;
                    int thumbTop = e.getY() - this.offset;
                    int trackTop = ((QuaquaSliderUI)QuaquaSliderUI.this).trackRect.y;
                    int trackBottom = ((QuaquaSliderUI)QuaquaSliderUI.this).trackRect.y + (((QuaquaSliderUI)QuaquaSliderUI.this).trackRect.height - 1);
                    int vMax = QuaquaSliderUI.this.yPositionForValue(QuaquaSliderUI.this.slider.getMaximum() - QuaquaSliderUI.this.slider.getExtent());
                    if (QuaquaSliderUI.this.drawInverted()) {
                        trackBottom = vMax;
                    } else {
                        trackTop = vMax;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    QuaquaSliderUI.this.setThumbLocation(((QuaquaSliderUI)QuaquaSliderUI.this).thumbRect.x, thumbTop);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    QuaquaSliderUI.this.slider.setValue(QuaquaSliderUI.this.valueForYPosition(thumbMiddle));
                    break;
                }
                case 0: {
                    int halfThumbWidth = ((QuaquaSliderUI)QuaquaSliderUI.this).thumbRect.width / 2;
                    int thumbLeft = e.getX() - this.offset;
                    int trackLeft = ((QuaquaSliderUI)QuaquaSliderUI.this).trackRect.x;
                    int trackRight = ((QuaquaSliderUI)QuaquaSliderUI.this).trackRect.x + (((QuaquaSliderUI)QuaquaSliderUI.this).trackRect.width - 1);
                    int hMax = QuaquaSliderUI.this.xPositionForValue(QuaquaSliderUI.this.slider.getMaximum() - QuaquaSliderUI.this.slider.getExtent());
                    if (QuaquaSliderUI.this.drawInverted()) {
                        trackLeft = hMax;
                    } else {
                        trackRight = hMax;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    QuaquaSliderUI.this.setThumbLocation(thumbLeft, ((QuaquaSliderUI)QuaquaSliderUI.this).thumbRect.y);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    QuaquaSliderUI.this.slider.setValue(QuaquaSliderUI.this.valueForXPosition(thumbMiddle));
                    break;
                }
                default: {
                    return;
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class Handler
    implements ChangeListener,
    ComponentListener,
    FocusListener,
    PropertyChangeListener {
        private Handler() {
        }

        public void stateChanged(ChangeEvent e) {
            if (!QuaquaSliderUI.this.isDragging) {
                QuaquaSliderUI.this.calculateThumbLocation();
                QuaquaSliderUI.this.slider.repaint();
            }
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            QuaquaSliderUI.this.calculateGeometry();
            QuaquaSliderUI.this.slider.repaint();
        }

        public void componentShown(ComponentEvent e) {
        }

        public void focusGained(FocusEvent e) {
            QuaquaSliderUI.this.slider.repaint();
        }

        public void focusLost(FocusEvent e) {
            QuaquaSliderUI.this.slider.repaint();
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name == "orientation" || name == "inverted" || name == "labelTable" || name == "majorTickSpacing" || name == "minorTickSpacing" || name == "paintTicks" || name == "paintTrack" || name == "paintLabels") {
                QuaquaSliderUI.this.calculateGeometry();
                QuaquaSliderUI.this.slider.repaint();
            } else if (name == "componentOrientation") {
                QuaquaSliderUI.this.calculateGeometry();
                QuaquaSliderUI.this.slider.repaint();
                InputMap km = QuaquaSliderUI.this.getInputMap(0, QuaquaSliderUI.this.slider);
                SwingUtilities.replaceUIInputMap(QuaquaSliderUI.this.slider, 0, km);
            } else if (name == "model") {
                ((BoundedRangeModel)e.getOldValue()).removeChangeListener(QuaquaSliderUI.this.changeListener);
                ((BoundedRangeModel)e.getNewValue()).addChangeListener(QuaquaSliderUI.this.changeListener);
                QuaquaSliderUI.this.calculateThumbLocation();
                QuaquaSliderUI.this.slider.repaint();
            } else if (name == "Frame.active") {
                QuaquaSliderUI.this.slider.repaint(QuaquaSliderUI.this.thumbRect);
            } else if (name.equals("JComponent.sizeVariant")) {
                QuaquaUtilities.applySizeVariant(QuaquaSliderUI.this.slider);
            }
        }
    }
}

