/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.subset;

import ch.randelshofer.quaqua.LookAndFeelProxy;
import ch.randelshofer.quaqua.osx.OSXPreferences;
import ch.randelshofer.quaqua.util.Images;
import java.awt.Color;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;

public class QuaquaPantherFileChooserLAF
extends LookAndFeelProxy {
    protected static final String commonDir = "/ch/randelshofer/quaqua/images/";
    protected static final String jaguarDir = "/ch/randelshofer/quaqua/jaguar/images/";
    protected static final String pantherDir = "/ch/randelshofer/quaqua/panther/images/";
    private UIDefaults myDefaults;
    protected static final FontUIResource SMALL_SYSTEM_FONT = new FontUIResource("Lucida Grande", 0, 11);

    public QuaquaPantherFileChooserLAF() {
        String targetClassName = "apple.laf.AquaLookAndFeel";
        try {
            this.setTarget((LookAndFeel)Class.forName(targetClassName).newInstance());
        }
        catch (Exception e) {
            throw new InternalError("Unable to instanciate target Look and Feel \"" + targetClassName + "\". " + e.getMessage());
        }
    }

    public String getDescription() {
        return "The Quaqua Panther FileChooser Look and Feel";
    }

    public String getName() {
        return "Quaqua FileChooser-only LAF";
    }

    public void initialize() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                QuaquaPantherFileChooserLAF.this.target.initialize();
                QuaquaPantherFileChooserLAF.this.myDefaults = QuaquaPantherFileChooserLAF.this.target.getDefaults();
                QuaquaPantherFileChooserLAF.this.initResourceBundle(QuaquaPantherFileChooserLAF.this.myDefaults);
                QuaquaPantherFileChooserLAF.this.initClassDefaults(QuaquaPantherFileChooserLAF.this.myDefaults);
                QuaquaPantherFileChooserLAF.this.initGeneralDefaults(QuaquaPantherFileChooserLAF.this.myDefaults);
                QuaquaPantherFileChooserLAF.this.initComponentDefaults(QuaquaPantherFileChooserLAF.this.myDefaults);
                return null;
            }
        });
    }

    public UIDefaults getDefaults() {
        return this.myDefaults;
    }

    protected void initResourceBundle(UIDefaults table) {
        ResourceBundle bundle = ResourceBundle.getBundle("ch.randelshofer.quaqua.Labels", Locale.getDefault(), this.getClass().getClassLoader());
        Enumeration<String> i = bundle.getKeys();
        while (i.hasMoreElements()) {
            String key = i.nextElement();
            table.put(key, bundle.getObject(key));
        }
    }

    protected void initClassDefaults(UIDefaults table) {
        String basicPrefix = "javax.swing.plaf.basic.Basic";
        String quaquaPrefix = "ch.randelshofer.quaqua.Quaqua";
        String quaquaPantherPrefix = "ch.randelshofer.quaqua.panther.QuaquaPanther";
        Object[] uiDefaults = new Object[]{"BrowserUI", quaquaPrefix + "BrowserUI", "FileChooserUI", quaquaPantherPrefix + "FileChooserUI"};
        table.putDefaults(uiDefaults);
    }

    protected void initGeneralDefaults(UIDefaults table) {
        Object[] uiDefaults = new Object[]{"ClassLoader", this.getClass().getClassLoader()};
        table.putDefaults(uiDefaults);
    }

    protected void initComponentDefaults(UIDefaults table) {
        String prefValue = OSXPreferences.getString(OSXPreferences.FINDER_PREFERENCES, "StandardViewOptions\tColumnViewOptions\tArrangeBy", "dnam");
        boolean isOrderFilesByType = prefValue.equals("kipl");
        prefValue = OSXPreferences.getString(OSXPreferences.FINDER_PREFERENCES, "AppleShowAllFiles", "false").toLowerCase();
        boolean isFileHidingEnabled = prefValue.equals("false") || prefValue.equals("no");
        FontUIResource smallSystemFont = SMALL_SYSTEM_FONT;
        Color grayedFocusCellBorderColor = (Color)table.get("listHighlight");
        Object[] uiDefaults = new Object[]{"Browser.expandedIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 0}), "Browser.expandingIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 1}), "Browser.focusedSelectedExpandedIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 2}), "Browser.focusedSelectedExpandingIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 3}), "Browser.selectedExpandedIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 4}), "Browser.selectedExpandingIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 5}), "Browser.selectionBackground", new ColorUIResource(56, 117, 215), "Browser.selectionForeground", new ColorUIResource(255, 255, 255), "Browser.inactiveSelectionBackground", new ColorUIResource(208, 208, 208), "Browser.inactiveSelectionForeground", new ColorUIResource(0, 0, 0), "Browser.sizeHandleIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/images/Browser.sizeHandleIcon.png", 1, Boolean.TRUE, 1}), "FileChooser.homeFolderIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/FileChooser.homeFolderIcon.png"), "FileView.computerIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/FileView.computerIcon.png"), "FileChooser.fileHidingEnabled", isFileHidingEnabled, "FileChooser.orderByType", isOrderFilesByType, "FileChooser.previewLabelForeground", new ColorUIResource(0), "FileChooser.previewValueForeground", new ColorUIResource(0), "FileChooser.previewLabelFont", smallSystemFont, "FileChooser.previewValueFont", smallSystemFont, "FileChooser.splitPaneDividerSize", 6, "FileChooser.previewLabelInsets", new InsetsUIResource(0, 0, 0, 4), "FileChooser.cellTipOrigin", new Point(18, 1), "FileChooser.autovalidate", Boolean.TRUE, "FileChooser.browserFocusCellHighlightBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", new Object[]{new Insets(1, 1, 1, 1)}), "FileChooser.browserFocusCellHighlightBorderGrayed", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$MatteBorderUIResource", new Object[]{1, 1, 1, 1, grayedFocusCellBorderColor}), "FileChooser.browserCellBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", new Object[]{new Insets(1, 1, 1, 1)}), "FileChooser.browserUseUnselectedExpandIconForLabeledFile", Boolean.TRUE, "Sheet.showAsSheet", Boolean.TRUE};
        table.putDefaults(uiDefaults);
    }

    protected URL getResource(String location) {
        URL url = this.getClass().getResource(location);
        if (url == null) {
            throw new InternalError("image resource missing: " + location);
        }
        return url;
    }

    protected Image createImage(String location) {
        return Toolkit.getDefaultToolkit().createImage(this.getResource(location));
    }

    protected Icon[] makeIcons(String location, int count, boolean horizontal) {
        Icon[] icons = new Icon[count];
        BufferedImage[] images = Images.split(this.createImage(location), count, horizontal);
        for (int i = 0; i < count; ++i) {
            icons[i] = new IconUIResource(new ImageIcon(images[i]));
        }
        return icons;
    }

    public String getID() {
        return "Aqua";
    }
}

