/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer.validate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.geom.util.PolygonExtracter;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BufferDistanceValidator {
    private static final double MAX_DISTANCE_DIFF_FRAC = 0.01;
    private Geometry input;
    private double distance;
    private Geometry result;
    private double minValidDistance;
    private double maxValidDistance;
    private boolean isValid = true;
    private Coordinate errorLocation = null;

    public BufferDistanceValidator(Geometry input, double distance, Geometry result) {
        this.input = input;
        this.distance = distance;
        this.result = result;
    }

    public boolean isValid() {
        double distDelta = 0.01 * this.distance;
        this.minValidDistance = this.distance - distDelta;
        this.maxValidDistance = this.distance + distDelta;
        if (this.input.isEmpty() || this.result.isEmpty()) {
            return true;
        }
        if (this.distance > 0.0) {
            this.checkPositiveValid();
        } else {
            this.checkNegativeValid();
        }
        return this.isValid;
    }

    public Coordinate getErrorLocation() {
        return this.errorLocation;
    }

    private void checkPositiveValid() {
        Geometry bufCurve = this.result.getBoundary();
        this.checkMinimumDistance(this.input, bufCurve, this.minValidDistance);
        if (!this.isValid) {
            return;
        }
        this.checkMaximumDistance(this.input, bufCurve, this.maxValidDistance);
    }

    private void checkNegativeValid() {
        if (!(this.input instanceof Polygon || this.input instanceof MultiPolygon || this.input instanceof GeometryCollection)) {
            return;
        }
        Geometry inputCurve = this.getPolygonLines(this.input);
        this.checkMinimumDistance(inputCurve, this.result, this.minValidDistance);
        if (!this.isValid) {
            return;
        }
        this.checkMaximumDistance(inputCurve, this.result, this.maxValidDistance);
    }

    private Geometry getPolygonLines(Geometry g) {
        ArrayList lines = new ArrayList();
        LinearComponentExtracter lineExtracter = new LinearComponentExtracter(lines);
        List polys = PolygonExtracter.getPolygons(g);
        Iterator i = polys.iterator();
        while (i.hasNext()) {
            Polygon poly = (Polygon)i.next();
            poly.apply(lineExtracter);
        }
        return g.getFactory().buildGeometry(lines);
    }

    private void checkMinimumDistance(Geometry inputCurve, Geometry buf, double minDist) {
        DistanceOp distOp = new DistanceOp(this.input, buf, minDist);
        double dist = distOp.distance();
        if (dist < minDist) {
            this.isValid = false;
            this.errorLocation = distOp.closestPoints()[1];
        }
    }

    private void checkMaximumDistance(Geometry input, Geometry buf, double maxDist) {
    }
}

