/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.jhotdraw.figures.ArrowTip;
import org.jhotdraw.figures.PolyLineFigure;
import org.jhotdraw.figures.PolyLineHandle;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.FigureChangeListener;
import org.jhotdraw.framework.FigureVisitor;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.ChangeConnectionEndHandle;
import org.jhotdraw.standard.ChangeConnectionStartHandle;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class LineConnection
extends PolyLineFigure
implements ConnectionFigure {
    protected Connector myStartConnector;
    protected Connector myEndConnector;
    private static final long serialVersionUID = 6883731614578414801L;
    private int lineConnectionSerializedDataVersion = 1;

    public LineConnection() {
        super(4);
        this.setStartDecoration(new ArrowTip());
        this.setEndDecoration(new ArrowTip());
    }

    public boolean canConnect() {
        return false;
    }

    protected void basicMoveBy(int n, int n2) {
        for (int i = 1; i < this.fPoints.size() - 1; ++i) {
            this.pointAt(i).translate(n, n2);
        }
        this.updateConnection();
    }

    public void connectStart(Connector connector) {
        this.setStartConnector(connector);
        if (connector != null) {
            this.startFigure().addDependendFigure(this);
            this.startFigure().addFigureChangeListener(this);
        }
    }

    public void connectEnd(Connector connector) {
        this.setEndConnector(connector);
        if (connector != null) {
            this.endFigure().addDependendFigure(this);
            this.endFigure().addFigureChangeListener(this);
            this.handleConnect(this.startFigure(), this.endFigure());
        }
    }

    public void disconnectStart() {
        this.startFigure().removeFigureChangeListener(this);
        this.startFigure().removeDependendFigure(this);
        this.setStartConnector(null);
    }

    public void disconnectEnd() {
        this.handleDisconnect(this.startFigure(), this.endFigure());
        this.endFigure().removeFigureChangeListener(this);
        this.endFigure().removeDependendFigure(this);
        this.setEndConnector(null);
    }

    public boolean connectsSame(ConnectionFigure connectionFigure) {
        return connectionFigure.getStartConnector() == this.getStartConnector() && connectionFigure.getEndConnector() == this.getEndConnector();
    }

    protected void handleDisconnect(Figure figure, Figure figure2) {
    }

    protected void handleConnect(Figure figure, Figure figure2) {
    }

    public Figure startFigure() {
        if (this.getStartConnector() != null) {
            return this.getStartConnector().owner();
        }
        return null;
    }

    public Figure endFigure() {
        if (this.getEndConnector() != null) {
            return this.getEndConnector().owner();
        }
        return null;
    }

    protected void setStartConnector(Connector connector) {
        this.myStartConnector = connector;
    }

    public Connector getStartConnector() {
        return this.myStartConnector;
    }

    protected void setEndConnector(Connector connector) {
        this.myEndConnector = connector;
    }

    public Connector getEndConnector() {
        return this.myEndConnector;
    }

    public boolean canConnect(Figure figure, Figure figure2) {
        return true;
    }

    public void startPoint(int n, int n2) {
        this.willChange();
        if (this.fPoints.size() == 0) {
            this.fPoints.add(new Point(n, n2));
        } else {
            this.fPoints.set(0, new Point(n, n2));
        }
        this.changed();
    }

    public void endPoint(int n, int n2) {
        this.willChange();
        if (this.fPoints.size() < 2) {
            this.fPoints.add(new Point(n, n2));
        } else {
            this.fPoints.set(this.fPoints.size() - 1, new Point(n, n2));
        }
        this.changed();
    }

    public Point startPoint() {
        Point point = this.pointAt(0);
        return new Point(point.x, point.y);
    }

    public Point endPoint() {
        if (this.fPoints.size() > 0) {
            Point point = this.pointAt(this.fPoints.size() - 1);
            return new Point(point.x, point.y);
        }
        return null;
    }

    public HandleEnumeration handles() {
        List list = CollectionsFactory.current().createList(this.fPoints.size());
        list.add(new ChangeConnectionStartHandle(this));
        for (int i = 1; i < this.fPoints.size() - 1; ++i) {
            list.add(new PolyLineHandle(this, LineConnection.locator(i), i));
        }
        list.add(new ChangeConnectionEndHandle(this));
        return new HandleEnumerator(list);
    }

    public void setPointAt(Point point, int n) {
        super.setPointAt(point, n);
        this.layoutConnection();
    }

    public void insertPointAt(Point point, int n) {
        super.insertPointAt(point, n);
        this.layoutConnection();
    }

    public void removePointAt(int n) {
        super.removePointAt(n);
        this.layoutConnection();
    }

    public void updateConnection() {
        Point point;
        if (this.getStartConnector() != null && (point = this.getStartConnector().findStart(this)) != null) {
            this.startPoint(point.x, point.y);
        }
        if (this.getEndConnector() != null && (point = this.getEndConnector().findEnd(this)) != null) {
            this.endPoint(point.x, point.y);
        }
    }

    public void layoutConnection() {
        this.updateConnection();
    }

    public void figureChanged(FigureChangeEvent figureChangeEvent) {
        this.updateConnection();
    }

    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
    }

    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
    }

    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
    }

    public void release() {
        super.release();
        this.handleDisconnect(this.startFigure(), this.endFigure());
        if (this.getStartConnector() != null) {
            this.startFigure().removeFigureChangeListener(this);
            this.startFigure().removeDependendFigure(this);
        }
        if (this.getEndConnector() != null) {
            this.endFigure().removeFigureChangeListener(this);
            this.endFigure().removeDependendFigure(this);
        }
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeStorable(this.getStartConnector());
        storableOutput.writeStorable(this.getEndConnector());
    }

    public void read(StorableInput storableInput) throws IOException {
        Connector connector;
        super.read(storableInput);
        Connector connector2 = (Connector)storableInput.readStorable();
        if (connector2 != null) {
            this.connectStart(connector2);
        }
        if ((connector = (Connector)storableInput.readStorable()) != null) {
            this.connectEnd(connector);
        }
        if (connector2 != null && connector != null) {
            this.updateConnection();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.getStartConnector() != null) {
            this.connectStart(this.getStartConnector());
        }
        if (this.getEndConnector() != null) {
            this.connectEnd(this.getEndConnector());
        }
    }

    public void visit(FigureVisitor figureVisitor) {
        figureVisitor.visitFigure(this);
    }

    public void removeFromContainer(FigureChangeListener figureChangeListener) {
        super.removeFromContainer(figureChangeListener);
        this.release();
    }
}

